/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.dsmd.dom;

import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.DsmdConfSpace;
import fr.exemole.bdfext.desmography.dsmd.dom.MotcleMatcher;
import java.text.ParseException;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedLocalKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class ConfDOMReader {
    private MotcleMatcher motcleMatcher;

    private ConfDOMReader(MotcleMatcher motcleMatcher) {
        this.motcleMatcher = motcleMatcher;
    }

    private void readConf(Element confElement) {
        DOMUtils.readChildren((Element)confElement, child -> {
            String tagName = child.getTagName();
            if (tagName.equals("param")) {
                String name = child.getAttribute("name");
                if (name.length() == 0) {
                    return;
                }
                String value = child.getAttribute("value");
                Attribute attribute = this.toAttribute(name, value);
                if (attribute != null) {
                    this.putAttribute(attribute);
                }
                this.convert(name, value);
            }
        });
    }

    private Attribute toAttribute(String name, String value) {
        try {
            CheckedLocalKey localKey = CheckedLocalKey.parse((CharSequence)name);
            AttributeKey attributeKey = AttributeKey.build((CheckedNameSpace)DsmdConfSpace.NAMESPACE, (CheckedLocalKey)localKey);
            if (value.length() > 0) {
                String[] tokens;
                AttributeBuilder builder = new AttributeBuilder(attributeKey);
                for (String token : tokens = StringUtils.getTokens((String)value, (char)';', (short)2)) {
                    builder.addValue(token);
                }
                return builder.toAttribute();
            }
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private void convert(String name, String value) {
        switch (name) {
            case "home.ventilationroot": {
                CleanedString home = this.getHome(value);
                if (home == null) break;
                this.putAttribute(AttributeBuilder.toAttribute((AttributeKey)DesmographySpace.HOME_KEY, (CleanedString)home));
            }
        }
    }

    private void putAttribute(Attribute attribute) {
        this.motcleMatcher.getFichothequeEditor().putAttribute((Object)this.motcleMatcher.getThesaurusMetadata(), attribute);
    }

    private CleanedString getHome(String value) {
        if (value.startsWith("descripteur:")) {
            Motcle motcle = this.motcleMatcher.matchDescripteur(value.substring("descripteur:".length()), false);
            return CleanedString.newInstance((CharSequence)String.valueOf(motcle.getId()));
        }
        return null;
    }

    public static void readConf(MotcleMatcher motcleMatcher, Element confElement) {
        new ConfDOMReader(motcleMatcher).readConf(confElement);
    }
}

