/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.commands;

import fr.exemole.bdfext.desmography.Desmography;
import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasTests;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.atlas.RelationEditor;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.LabelChange;

public class TermAddCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TermAdd";
    public static final String MODE_PARAMNAME = "mode";
    public static final String NEW_MODE_PARAMVALUE = "new";
    public static final String EXISTING_MODE_PARAMVALUE = "existing";
    public static final String RELATION_PARAMNAME = "relation";
    public static final String TERM_PARAMNAME = "term";
    public static final String SUPERIOR_PARAMNAME = "superior";
    public static final String LABEL_PARAMPREFIX = "label/";
    private Atlas atlas;
    private String relationType;
    private TermSource termSource;
    private TermAdd termAdd;

    public TermAddCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession(Desmography.DOMAIN, COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            RelationEditor relationEditor = RelationEditor.newInstance((BdfParameters)this.requestHandler, fichothequeEditor, this.atlas);
            Motcle term = this.termSource.get(fichothequeEditor.getThesaurusEditor(this.atlas.getTermThesaurus()));
            this.termAdd.add(relationEditor, term);
        }
        this.setDone("_ done.desmography.termadd", new Object[0]);
    }

    protected void checkParameters() throws ErrorMessageException {
        this.atlas = DesmographyUtils.getAtlas(this.requestHandler);
        this.termAdd = this.initTermAdd();
        this.termSource = this.initTermSource();
    }

    private TermSource initTermSource() throws ErrorMessageException {
        String mode;
        switch (mode = this.getMandatory(MODE_PARAMNAME)) {
            case "existing": {
                return this.initExistingTermSource();
            }
            case "new": {
                return new NewTermSource(BdfCommandUtils.getLabelChange((RequestMap)this.requestHandler.getRequestMap(), (String)LABEL_PARAMPREFIX, (boolean)true));
            }
        }
        throw BdfErrors.unknownParameterValue((String)MODE_PARAMNAME, (String)mode);
    }

    private TermSource initExistingTermSource() throws ErrorMessageException {
        Motcle term;
        String idString = this.getMandatory(TERM_PARAMNAME);
        try {
            int id = Integer.parseInt(idString);
            term = this.atlas.getTermThesaurus().getMotcleById(id);
        }
        catch (NumberFormatException nfe) {
            term = this.atlas.getTermThesaurus().getMotcleByIdalpha(idString);
        }
        if (term == null) {
            throw BdfErrors.error((String)"_ error.wrong.id", (Object[])new Object[]{idString});
        }
        switch (this.relationType) {
            case "grids": 
            case "subsectors": {
                if (!AtlasTests.isInGrids(this.atlas, term)) break;
                throw BdfErrors.error((String)"_ error.unsupported.desmography.gridalready", (Object[])new Object[]{idString});
            }
            case "rootfamilies": 
            case "subfamilies": {
                if (!AtlasTests.isInFamilies(this.atlas, term)) break;
                throw BdfErrors.error((String)"_ error.unsupported.desmography.familyalready", (Object[])new Object[]{idString});
            }
        }
        if (AtlasTests.isInGrids(this.atlas, term)) {
            // empty if block
        }
        return new MotcleTermSource(term);
    }

    private TermAdd initTermAdd() throws ErrorMessageException {
        String relationString;
        this.relationType = relationString = this.getMandatory(RELATION_PARAMNAME);
        switch (relationString) {
            case "grids": {
                return new GridTermAdd();
            }
            case "rootfamilies": {
                return new RootFamilyTermAdd();
            }
            case "subsectors": {
                return new SubsectorTermAdd(this.getSuperior());
            }
            case "subfamilies": {
                return new SubfamilyTermAdd(this.getSuperior());
            }
        }
        try {
            int id = Integer.parseInt(relationString);
            FicheMeta relation = this.atlas.getRelationCorpus().getFicheMetaById(id);
            if (relation == null) {
                throw BdfErrors.unknownParameterValue((String)RELATION_PARAMNAME, (String)relationString);
            }
            this.relationType = AtlasUtils.getRelationType(relation);
            return new FicheMetaTermAdd(relation);
        }
        catch (NumberFormatException nfe) {
            throw BdfErrors.wrongParameterValue((String)RELATION_PARAMNAME, (String)relationString);
        }
    }

    private Motcle getSuperior() throws ErrorMessageException {
        String superiorName = this.getMandatory(SUPERIOR_PARAMNAME);
        Motcle superior = null;
        try {
            int id = Integer.parseInt(superiorName);
            superior = this.atlas.getTermThesaurus().getMotcleById(id);
        }
        catch (NumberFormatException nfe) {
            superior = this.atlas.getTermThesaurus().getMotcleByIdalpha(superiorName);
        }
        if (superior == null) {
            throw BdfErrors.wrongParameterValue((String)SUPERIOR_PARAMNAME, (String)superiorName);
        }
        return superior;
    }

    private static abstract class TermSource {
        private TermSource() {
        }

        protected abstract Motcle get(ThesaurusEditor var1);
    }

    private static abstract class TermAdd {
        private TermAdd() {
        }

        protected abstract void add(RelationEditor var1, Motcle var2);
    }

    private static class NewTermSource
    extends TermSource {
        private final LabelChange labelChange;

        private NewTermSource(LabelChange labelChange) {
            this.labelChange = labelChange;
        }

        @Override
        protected Motcle get(ThesaurusEditor thesaurusEditor) {
            try {
                Motcle motcle = thesaurusEditor.createMotcle(-1, null);
                ThesaurusUtils.changeMotcleLabels((ThesaurusEditor)thesaurusEditor, (Motcle)motcle, (LabelChange)this.labelChange);
                return motcle;
            }
            catch (ParseException | ExistingIdException e) {
                throw new ShouldNotOccurException((Exception)e);
            }
        }
    }

    private static class MotcleTermSource
    extends TermSource {
        private final Motcle motcle;

        private MotcleTermSource(Motcle motcle) {
            this.motcle = motcle;
        }

        @Override
        protected Motcle get(ThesaurusEditor thesaurusEditor) {
            return this.motcle;
        }
    }

    private static class GridTermAdd
    extends TermAdd {
        private GridTermAdd() {
        }

        @Override
        protected void add(RelationEditor relationEditor, Motcle motcle) {
            relationEditor.addGrid(motcle);
        }
    }

    private static class RootFamilyTermAdd
    extends TermAdd {
        private RootFamilyTermAdd() {
        }

        @Override
        protected void add(RelationEditor relationEditor, Motcle motcle) {
            relationEditor.addRootFamily(motcle);
        }
    }

    private static class SubsectorTermAdd
    extends TermAdd {
        private final Motcle superior;

        private SubsectorTermAdd(Motcle superior) {
            this.superior = superior;
        }

        @Override
        protected void add(RelationEditor relationEditor, Motcle motcle) {
            relationEditor.addSubsector(this.superior, motcle);
        }
    }

    private static class SubfamilyTermAdd
    extends TermAdd {
        private final Motcle superior;

        private SubfamilyTermAdd(Motcle superior) {
            this.superior = superior;
        }

        @Override
        protected void add(RelationEditor relationEditor, Motcle motcle) {
            relationEditor.addSubfamily(this.superior, motcle);
        }
    }

    private static class FicheMetaTermAdd
    extends TermAdd {
        private final FicheMeta ficheMeta;

        private FicheMetaTermAdd(FicheMeta ficheMeta) {
            this.ficheMeta = ficheMeta;
        }

        @Override
        protected void add(RelationEditor relationEditor, Motcle motcle) {
            relationEditor.appendInferior(this.ficheMeta, motcle);
        }
    }
}

