/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.atlas;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;

public final class AtlasLoops {
    private AtlasLoops() {
    }

    public static void forEachSubsector(Atlas atlas, Motcle term, Consumer<Motcle> subsectorConsumer) {
        List<FicheMeta> subsectorRelationList = AtlasUtils.getRelationList(atlas, term, "superior", "subsectors");
        for (FicheMeta relation : subsectorRelationList) {
            List<Motcle> subsectorTermList = AtlasUtils.inferiors(atlas, relation);
            for (Motcle subsector : subsectorTermList) {
                subsectorConsumer.accept(subsector);
            }
        }
    }

    public static void forEachSubfamily(Atlas atlas, Motcle family, Consumer<Motcle> subfamilyConsumer) {
        List<FicheMeta> subfamilyRelationList = AtlasUtils.getRelationList(atlas, family, "superior", "subfamilies");
        for (FicheMeta relation : subfamilyRelationList) {
            List<Motcle> subfamilyTermList = AtlasUtils.inferiors(atlas, relation);
            for (Motcle subfamily : subfamilyTermList) {
                subfamilyConsumer.accept(subfamily);
            }
        }
    }

    public static void forEachFamilyMember(Atlas atlas, Motcle family, Consumer<Motcle> memberConsumer) {
        List<FicheMeta> memberRelationList = AtlasUtils.getRelationList(atlas, family, "superior", "family");
        for (FicheMeta relation : memberRelationList) {
            List<Motcle> memberTermList = AtlasUtils.inferiors(atlas, relation);
            for (Motcle member : memberTermList) {
                memberConsumer.accept(member);
            }
        }
    }

    public static void forEachHierachyRelation(Atlas atlas, Consumer<FicheMeta> relationConsumer) {
        for (FicheMeta ficheMeta : atlas.getRelationCorpus().getFicheMetaList()) {
            if (!AtlasUtils.getRelationType(ficheMeta).equals("hierarchy")) continue;
            relationConsumer.accept(ficheMeta);
        }
    }
}

