/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography;

import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasBuilder;
import fr.exemole.bdfext.desmography.atlas.export.ScrutariExportEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.providers.HookHandlerProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.hook.HookHandler;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Phrase;
import net.scrutari.dataexport.api.ScrutariDataExport;
import net.scrutari.dataexport.api.ThesaurusMetadataExport;

public class DesmographyHookHandlerProvider
implements HookHandlerProvider {
    public HookHandler getHookHandler(BdfServer bdfServer, @Nullable BdfUser bdfUser, String hookHandlerName) {
        switch (hookHandlerName) {
            case "ScrutariExport": {
                return new ScrutariExportHookHandler(bdfServer);
            }
        }
        return null;
    }

    private static class ScrutariExportHookHandler
    implements HookHandler {
        private final BdfServer bdfServer;
        private final List<Atlas> desmographyList = new ArrayList<Atlas>();

        private ScrutariExportHookHandler(BdfServer bdfServer) {
            this.bdfServer = bdfServer;
        }

        public void handle(String hookName, Object ... arguments) {
            switch (hookName) {
                case "BaseMetadata": {
                    break;
                }
                case "CorpusMetadata": {
                    break;
                }
                case "ThesaurusMetadata": {
                    this.handleThesaurus(arguments);
                    break;
                }
                case "End": {
                    this.handleEnd(arguments);
                }
            }
        }

        private void handleThesaurus(Object[] arguments) {
            ThesaurusMetadataExport thesaurusMetadataExport = (ThesaurusMetadataExport)arguments[0];
            ThesaurusMetadata thesaurusMetadata = (ThesaurusMetadata)arguments[1];
            List hookList = (List)arguments[2];
            boolean here = false;
            for (String hook : hookList) {
                if (!hook.equals("desmography")) continue;
                here = true;
            }
            if (!here) {
                return;
            }
            Corpus relationCorpus = DesmographyUtils.getRelationCorpus(thesaurusMetadata.getThesaurus());
            if (relationCorpus != null) {
                Atlas desmography = AtlasBuilder.build(this.bdfServer, thesaurusMetadata.getThesaurus(), relationCorpus);
                Phrase titleLabels = thesaurusMetadata.getPhrases().getPhrase("desmography.title");
                if (titleLabels != null) {
                    for (Label label : titleLabels) {
                        thesaurusMetadataExport.addPhraseLabel("desmography.title", label.getLang().toString(), label.getLabelString());
                    }
                }
                this.desmographyList.add(desmography);
            }
        }

        private void handleEnd(Object[] arguments) {
            ScrutariDataExport scrutariDataExport = (ScrutariDataExport)arguments[0];
            for (Atlas desmography : this.desmographyList) {
                ScrutariExportEngine.exportRelations(scrutariDataExport, desmography);
            }
        }
    }
}

