/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography;

import fr.exemole.bdfext.desmography.DesmographyActionProvider;
import fr.exemole.bdfext.desmography.DesmographyBdfCommandProvider;
import fr.exemole.bdfext.desmography.DesmographyBdfInstructionProvider;
import fr.exemole.bdfext.desmography.DesmographyHookHandlerProvider;
import fr.exemole.bdfext.desmography.DesmographyHtmlProducerProvider;
import fr.exemole.bdfext.desmography.DesmographyJsonProducerProvider;
import fr.exemole.bdfext.desmography.DesmographyMetadataPhraseDefProvider;
import fr.exemole.bdfext.desmography.DesmographyTableInclusionResolverProvider;
import fr.exemole.bdfserver.api.BdfExtensionInitializer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.providers.ActionProvider;
import fr.exemole.bdfserver.api.providers.BdfCommandProvider;
import fr.exemole.bdfserver.api.providers.BdfInstructionProvider;
import fr.exemole.bdfserver.api.providers.HookHandlerProvider;
import fr.exemole.bdfserver.api.providers.HtmlProducerProvider;
import fr.exemole.bdfserver.api.providers.JsonProducerProvider;
import fr.exemole.bdfserver.api.providers.MetadataPhraseDefProvider;
import fr.exemole.bdfserver.api.storage.BdfExtensionStorage;
import fr.exemole.bdfserver.tools.storage.DirectoryEditableResourceStorage;
import java.io.File;
import net.fichotheque.Fichotheque;
import net.fichotheque.exportation.table.TableInclusionResolverProvider;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;

public class DesmographyBdfExtensionInitializer
implements BdfExtensionInitializer {
    public String getRegistrationName() {
        return "desmography";
    }

    public BdfExtensionInitializer.Factory init(BdfExtensionStorage bdfExtensionStorage, Fichotheque fichotheque) {
        File dataDirectory = bdfExtensionStorage.getDataDirectory("desmography");
        File backupDirectory = bdfExtensionStorage.getBackupDirectory("desmography");
        DirectoryEditableResourceStorage dataStorage = new DirectoryEditableResourceStorage("desmography", dataDirectory, backupDirectory);
        return new InternalFactory();
    }

    private static class InternalFactory
    implements BdfExtensionInitializer.Factory {
        private InternalFactory() {
        }

        public Object getImplementation(BdfServer bdfServer, Class interfaceClass) {
            if (interfaceClass.equals(HtmlProducerProvider.class)) {
                return new DesmographyHtmlProducerProvider();
            }
            if (interfaceClass.equals(BdfCommandProvider.class)) {
                return new DesmographyBdfCommandProvider();
            }
            if (interfaceClass.equals(BdfInstructionProvider.class)) {
                return new DesmographyBdfInstructionProvider();
            }
            if (interfaceClass.equals(ActionProvider.class)) {
                return new DesmographyActionProvider();
            }
            if (interfaceClass.equals(MetadataPhraseDefProvider.class)) {
                return new DesmographyMetadataPhraseDefProvider();
            }
            if (interfaceClass.equals(JsonProducerProvider.class)) {
                return new DesmographyJsonProducerProvider();
            }
            if (interfaceClass.equals(TableInclusionResolverProvider.class)) {
                return new DesmographyTableInclusionResolverProvider(bdfServer);
            }
            if (interfaceClass.equals(HookHandlerProvider.class)) {
                return new DesmographyHookHandlerProvider();
            }
            if (interfaceClass.equals(Message.class)) {
                return LocalisationUtils.toMessage((String)"_ title.desmography.extension");
            }
            return null;
        }
    }
}

