/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.io.IOException;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasFilter;
import net.desmodo.atlas.TermSpaceManager;
import net.desmodo.atlas.xml.api.DescripteursXMLPart;
import net.desmodo.atlas.xml.api.LiensXMLPart;
import net.desmodo.atlas.xml.api.MetadataXMLPart;
import net.desmodo.atlas.xml.api.StructureXMLPart;
import net.mapeadores.util.script.ScriptFamily;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class AtlasXMLPart
extends XMLPart {
    private final TermSpaceManager termSpaceManager;
    private final AtlasFilter atlasFilter;
    private boolean oldCrtxml = false;
    private final ScriptFamily scriptFamily;

    public AtlasXMLPart(XMLWriter xmlWriter, TermSpaceManager termSpaceManager, AtlasFilter atlasFilter, ScriptFamily scriptFamily) {
        super(xmlWriter);
        this.termSpaceManager = termSpaceManager;
        this.atlasFilter = atlasFilter;
        this.scriptFamily = scriptFamily;
    }

    public void addAtlas(Atlas atlas) throws IOException {
        this.openTag("atlas");
        MetadataXMLPart mxp = new MetadataXMLPart(this.getXMLWriter());
        mxp.addMetadata(atlas.getAtlasMetadata());
        StructureXMLPart sxp = new StructureXMLPart(this.getXMLWriter(), this.atlasFilter);
        sxp.setOldCrtxml(this.oldCrtxml);
        sxp.addStructure(atlas.getStructure());
        if (!this.atlasFilter.onlyStructure()) {
            DescripteursXMLPart dxp = new DescripteursXMLPart(this.getXMLWriter(), this.termSpaceManager, this.atlasFilter);
            dxp.setOldCrtxml(this.oldCrtxml);
            dxp.addDescripteurs(atlas.getDescripteurs());
            LiensXMLPart lxp = new LiensXMLPart(this.getXMLWriter(), this.termSpaceManager, this.atlasFilter, this.scriptFamily);
            lxp.setOldCrtxml(this.oldCrtxml);
            lxp.addLiens(atlas.getLiens());
        }
        this.closeTag("atlas");
    }

    public void setOldCrtxml(boolean oldCrtxml) {
        this.oldCrtxml = oldCrtxml;
    }
}

