/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.htmlpages;

import fr.exemole.bdfext.cef.htmlpages.CefHtmlPage;
import fr.exemole.bdfext.cef.htmlpages.CefHtmlPrinter;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import java.util.TreeMap;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;

public class StatutPage
extends CefHtmlPage {
    private final Thesaurus statut = this.getThesaurus("statut2010");
    private final Thesaurus atelierPermanentThesaurus = this.getThesaurus("atelierpermanent");
    private final Corpus atelierBiennale = this.getCorpus("atelier2010");

    public StatutPage(BdfServer bdfServer, BdfUser bdfUser) {
        super(bdfServer, bdfUser);
    }

    @Override
    public CefHtmlPrinter getCefHtmlPrinter() {
        return new StatutPrinter();
    }

    private class StatutPrinter
    extends CefHtmlPrinter {
        private StatutPrinter() {
        }

        @Override
        public void printPage() {
            this.start(StatutPage.this.workingLang, "CEF");
            this.UL();
            for (Motcle motcle : StatutPage.this.statut.getFirstLevelList()) {
                this.printStatutMotcle(motcle);
            }
            this._UL();
            this.end();
        }

        private void printStatutMotcle(Motcle statutMotcle) {
            TreeMap<String, Motcle> atelierSet = new TreeMap<String, Motcle>();
            Junctions ficheJunctions = StatutPage.this.fichotheque.getJunctions((SubsetItem)statutMotcle, (Subset)StatutPage.this.atelierBiennale);
            for (Junctions.Entry entry : ficheJunctions.getEntryList()) {
                FicheMeta atelier2010 = (FicheMeta)entry.getSubsetItem();
                Junctions atelierPermanentJunctions = StatutPage.this.fichotheque.getJunctions((SubsetItem)atelier2010, (Subset)StatutPage.this.atelierPermanentThesaurus);
                if (atelierPermanentJunctions.isEmpty()) continue;
                Motcle atelierPermanent = (Motcle)atelierPermanentJunctions.getFirstSubsetItem();
                atelierSet.put(atelierPermanent.getIdalpha(), atelierPermanent);
            }
            this.LI();
            this.DIV().__escape((CharSequence)statutMotcle.getIdalpha()).__escape((CharSequence)" - ").__escape((CharSequence)statutMotcle.getLabelString(StatutPage.this.workingLang))._DIV();
            this.UL();
            HtmlAttributes aAttributes = new HtmlAttributes();
            for (Motcle atelierPermanent : atelierSet.values()) {
                String idalpha = atelierPermanent.getIdalpha();
                aAttributes.href((CharSequence)("Atelier-" + idalpha));
                this.LI().A(aAttributes).__(BdfHtmlUtils.printMotcleTitle((HtmlPrinter)this, (Motcle)atelierPermanent, (Lang)StatutPage.this.workingLang))._A()._LI();
            }
            this._UL();
            this._LI();
        }
    }
}

