/* FichothequeLib_Tools - Copyright (c) 2018-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.format;

import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.mapeadores.util.exceptions.SwitchException;


/**
 *
 * @author Vincent Calame
 */
public final class DefaultPatternCatalog {

    public final static String ATTRIBUTE = "{value}";
    public final static String DOCUMENT = "{basename}{extensions}";
    public final static String EXTRACTION = "{xml}";
    public final static String FICHEBLOCK = "{text}";
    public final static String FICHEMETA = "{title}";
    public final static String ILLUSTRATION = "{album}-{id}.{format}";
    public final static String VALUE = "{value}";

    private DefaultPatternCatalog() {

    }

    public static String ficheItem(String ficheItemType) {
        switch (ficheItemType) {
            case CorpusField.PERSON_FIELD:
                return "{normal}";
            case CorpusField.LANGUAGE_FIELD:
                return "{code}";
            case CorpusField.DATE_FIELD:
                return "{code}";
            case CorpusField.COUNTRY_FIELD:
                return "{code}";
            case CorpusField.NUMBER_FIELD:
                return "{code}";
            case CorpusField.AMOUNT_FIELD:
                return "{code}";
            case CorpusField.EMAIL_FIELD:
                return "{address}";
            case CorpusField.LINK_FIELD:
                return "{href}";
            case CorpusField.ITEM_FIELD:
                return "{value}";
            case CorpusField.GEOPOINT_FIELD:
                return "{lat} {lon}";
            case CorpusField.PARA_FIELD:
                return "{raw}";
            case CorpusField.IMAGE_FIELD:
                return "{src}";
            default:
                throw new SwitchException("ficheItemType = " + ficheItemType);
        }
    }


    public static String motcle(boolean withIdalpha) {
        if (withIdalpha) {
            return "{idalpha}";
        } else {
            return "{label}";
        }
    }

    public static String subfield(String subfieldType) {
        switch (subfieldType) {
            case SubfieldKey.SURNAME_SUBTYPE:
            case SubfieldKey.FORENAME_SUBTYPE:
            case SubfieldKey.NONLATIN_SUBTYPE:
            case SubfieldKey.SURNAMEFIRST_SUBTYPE:
            case SubfieldKey.SRC_SUBTYPE:
            case SubfieldKey.ALT_SUBTYPE:
            case SubfieldKey.TITLE_SUBTYPE:
            case SubfieldKey.LATITUDE_SUBTYPE:
            case SubfieldKey.LONGITUDE_SUBTYPE:
            case SubfieldKey.CURRENCY_SUBTYPE:
            case SubfieldKey.VALUE_SUBTYPE:
                return "{value}";
            case SubfieldKey.OTHERS_SUBTYPE:
                return "{code}";
            case SubfieldKey.AMOUNT_SUBTYPE:
                return "{value}";
            case SubfieldKey.LANG_SUBTYPE:
            default:
                throw new SwitchException("subfieldType = " + subfieldType);
        }
    }


}
