/* FichothequeLib_Tools - Copyright (c) 2008-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.conversion.fieldtofield;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.ConversionUtils;
import net.mapeadores.util.logging.MultiMessageHandler;


/**
 *
 * @author Vincent Calame
 */
class SectionToFicheItemField extends FieldToFieldConverter {

    private final FieldKey sourceKey;
    private final FieldKey destinationKey;

    SectionToFicheItemField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.sourceKey = sourceKey;
        this.destinationKey = destinationKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        FicheBlocks ficheBlocks = fiche.getSection(sourceKey);
        if ((ficheBlocks == null) || (ficheBlocks.isEmpty())) {
            return;
        }
        List<ParaItem> paraItemList = new ArrayList<ParaItem>();
        boolean onlyP = ConversionUtils.appendPara(paraItemList, ficheBlocks);
        if (!onlyP) {
            addWarning("_ warning.conversion.containsnotonlyp", sourceKey.getKeyString());
        }
        int size = paraItemList.size();
        if (size == 0) {
            return;
        }
        if (destinationKey.isProp()) {
            FicheItem ficheItem = paraItemList.get(0);
            fiche.setProp(destinationKey, ficheItem);
            if (size > 1) {
                addWarning("_ warning.conversion.manyficheblocks", sourceKey.getKeyString());
            }
        } else {
            fiche.appendInfo(destinationKey, ConversionUtils.toFicheItems(paraItemList));
        }
        if (removeOldField) {
            fiche.setSection(sourceKey, null);
        }
    }


}
