/* FichothequeLib_API - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.importation;

import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheChange;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.date.FuzzyDate;


/**
 *
 * @author Vincent Calame
 */
public interface CorpusImport {

    public final static String EDIT_TYPE = "edit";
    public final static String REMOVE_TYPE = "remove";

    public Corpus getCorpus();

    public String getType();

    public List<FicheImport> getFicheImportList();

    public static String checkType(String type) {
        switch (type) {
            case "creation":
            case "change":
            case EDIT_TYPE:
                return EDIT_TYPE;
            case REMOVE_TYPE:
                return REMOVE_TYPE;
            default:
                throw new IllegalArgumentException("Unknown type: " + type);
        }
    }


    public interface FicheImport {

        public int getFicheId();

    }


    public interface EditFicheImport extends FicheImport {

        public FicheChange getFicheChange();

        public AttributeChange getAttributeChange();

        public TiesImport getTiesImport();

        public FuzzyDate getCreationDate();

    }


    public interface ChangeFicheImport extends EditFicheImport {

    }


    public interface CreationFicheImport extends EditFicheImport {

        public int getNewId();

    }

}
