/* FichothequeLib_API - Copyright (c) 2007-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.exportation.table;

import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.format.Calcul;
import net.mapeadores.util.format.FormatConstants;
import net.mapeadores.util.format.FormatUtils;
import net.mapeadores.util.text.Labels;


/**
 *
 * @author Vincent Calame
 */
public interface ColDef {

    /**
     * N'est jamais nul.
     */
    public String getColName();

    /**
     * Nul s'il faut utiliser le libellé par défaut
     */
    @Nullable
    public Labels getCustomLabels();

    @Nullable
    public Object getParameterValue(String paramKey);

    public default String getCastType() {
        if (FormatUtils.toBoolean(getParameterValue(FormatConstants.JSONARRAY_PARAMKEY))) {
            return FormatConstants.JSON_CAST;
        }
        Object value = getParameterValue(FormatConstants.CAST_PARAMKEY);
        if (value == null) {
            return "";
        }
        try {
            return ((String) value);
        } catch (ClassCastException cce) {
            return "";
        }
    }

    public default boolean isSum() {
        return (getParameterValue(FormatConstants.SUM_PARAMKEY) != null);
    }

    public default String getSumCastType() {
        Object value = getParameterValue(FormatConstants.SUM_PARAMKEY);
        String sumCastType = "";
        if (value != null) {
            try {
                sumCastType = (String) value;
            } catch (ClassCastException cce) {
            }
        }
        if (sumCastType.isEmpty()) {
            sumCastType = getCastType();
        }

        return sumCastType;
    }

    public default boolean isFormula() {
        return (getParameterValue(FormatConstants.FORMULA_PARAMKEY) != null);
    }

    public default String getFormulaCastType() {
        Object value = getParameterValue(FormatConstants.FORMULA_PARAMKEY);
        if (value == null) {
            return "";
        }
        try {
            return ((String) value);
        } catch (ClassCastException cce) {
            return "";
        }
    }

    public default boolean isWithColumnSum() {
        return FormatUtils.toBoolean(getParameterValue(FormatConstants.COLUMNSUM_PARAMKEY));
    }

    public default boolean isConvertEmptyToNull() {
        return FormatUtils.toBoolean(getParameterValue(FormatConstants.EMPTYTONULL_PARAMKEY));
    }

    public default Calcul getCalcul() {
        return FormatUtils.toCalcul(getParameterValue(FormatConstants.CALCUL_PARAMKEY));
    }

    public default String getMatchingComponentName() {
        return "";
    }

}
