/* BdfServer - Copyright (c) 2026 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.tools.filesupload;

import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;


/**
 *
 * @author Vincent Calame
 */
public class UploadError {

    private final TmpFileInfo tmpFileInfo;
    private final Message message;

    public UploadError(TmpFileInfo tmpFileInfo, Message message) {
        this.tmpFileInfo = tmpFileInfo;
        this.message = message;
    }

    public TmpFileInfo getTmpFileInfo() {
        return tmpFileInfo;
    }

    public Message getMessage() {
        return message;
    }

    public static UploadError build(TmpFileInfo tmpFileInfo, String messageKey) {
        return new UploadError(tmpFileInfo, LocalisationUtils.toMessage(messageKey));
    }

    public static UploadError build(TmpFileInfo tmpFileInfo, String messageKey, Object... messageValues) {
        return new UploadError(tmpFileInfo, LocalisationUtils.toMessage(messageKey, messageValues));
    }

}
