/* BdfServer - Copyright (c) 2009-2026 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.tools.ficheform;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormEntry;
import fr.exemole.bdfserver.api.ficheform.FormEntryProvider;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.builders.AddendaEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.AlbumEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.CorpusEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.LiageEntryBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.field.FieldEntryFactory;
import fr.exemole.bdfserver.tools.ficheform.builders.thesaurus.ThesaurusEntryFactory;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;


/**
 *
 * @author Vincent Calame
 */
public final class FormEntryProviderFactory {

    private FormEntryProviderFactory() {
    }

    public static FormEntryProvider newInstance(FicheFormParameters ficheFormParameters) {
        return new InternalFormEntryProvider(ficheFormParameters);
    }


    private static class InternalFormEntryProvider implements FormEntryProvider {

        private final FicheFormParameters ficheFormParameters;

        public InternalFormEntryProvider(FicheFormParameters ficheFormParameters) {
            this.ficheFormParameters = ficheFormParameters;
        }

        @Override
        public FormEntry.Include getFormEntry(FichePointeur fichePointeur, IncludeUi includeUi) {
            if (includeUi instanceof SpecialIncludeUi) {
                SpecialIncludeUi specialIncludeUi = (SpecialIncludeUi) includeUi;
                if (!FicheFormUtils.hasAccess(ficheFormParameters, specialIncludeUi)) {
                    return null;
                }
                switch (specialIncludeUi.getName()) {
                    case FichothequeConstants.LIAGE_NAME:
                        LiageEntryBuilder builder = LiageEntryBuilder.check(fichePointeur, ficheFormParameters, specialIncludeUi);
                        if (builder != null) {
                            return builder.toLiageEntry();
                        } else {
                            return null;
                        }

                    default:
                        return null;
                }
            } else if (includeUi instanceof SubsetIncludeUi) {
                SubsetIncludeUi subsetIncludeUi = (SubsetIncludeUi) includeUi;
                if (!FicheFormUtils.hasAccess(ficheFormParameters, subsetIncludeUi)) {
                    return null;
                }
                switch (subsetIncludeUi.getCategory()) {
                    case SubsetKey.CATEGORY_ADDENDA: {
                        AddendaEntryBuilder builder = AddendaEntryBuilder.check(fichePointeur, ficheFormParameters, subsetIncludeUi, ficheFormParameters.isDuplicate());
                        if (builder != null) {
                            return builder.toAddendaEntry();
                        } else {
                            return null;
                        }
                    }
                    case SubsetKey.CATEGORY_ALBUM: {
                        AlbumEntryBuilder builder = AlbumEntryBuilder.check(fichePointeur, ficheFormParameters, subsetIncludeUi);
                        if (builder != null) {
                            return builder.toAlbumEntry();
                        } else {
                            return null;
                        }
                    }
                    case SubsetKey.CATEGORY_CORPUS: {
                        CorpusEntryBuilder builder = CorpusEntryBuilder.check(fichePointeur, ficheFormParameters, subsetIncludeUi);
                        if (builder != null) {
                            return builder.toCorpusEntry();
                        } else {
                            return null;
                        }
                    }
                    case SubsetKey.CATEGORY_THESAURUS: {
                        return ThesaurusEntryFactory.newInstance(fichePointeur, ficheFormParameters, subsetIncludeUi);
                    }
                    default:
                        return null;
                }
            } else {
                return null;
            }
        }

        @Override
        public FormEntry.Field getFormEntry(FichePointeur fichePointeur, FieldUi fieldUi) {
            CorpusField corpusField = FicheFormUtils.getCorpusField(fichePointeur, fieldUi);
            if (corpusField == null) {
                return null;
            }
            if (corpusField.isGenerated()) {
                return null;
            }
            if (!FicheFormUtils.hasAccess(ficheFormParameters, fieldUi)) {
                return null;
            }
            return FieldEntryFactory.newInstance(fichePointeur, ficheFormParameters, corpusField, fieldUi);
        }

    }

}
