/* BdfServer_API - Copyright (c) 2020-2026 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.api.instruction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.extraction.builders.ExtractionContextBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;


/**
 *
 * @author Vincent Calame
 */
public interface BdfParameters {

    public BdfServer getBdfServer();

    public BdfUser getBdfUser();

    public PermissionSummary getPermissionSummary();

    public default Fichotheque getFichotheque() {
        return getBdfServer().getFichotheque();
    }

    public default Lang getWorkingLang() {
        return getBdfUser().getWorkingLang();
    }

    public default UserLangContext getUserLangContext() {
        return getBdfUser();
    }

    public default MessageLocalisation getMessageLocalisation() {
        return getBdfServer().getL10nManager().getMessageLocalisation(getBdfUser());
    }

    public default boolean isFichothequeAdmin() {
        return getBdfServer().getPermissionManager().isAdmin(getBdfUser().getRedacteur());
    }

    public default ExtractionContextBuilder getExtractionContextBuilder() {
        return BdfServerUtils.initExtractionContextBuilder(getBdfServer(), getBdfUser(), getPermissionSummary());
    }

    public default ExtractionContext getDefaultExtractionContext() {
        return getExtractionContextBuilder().toExtractionContext();
    }

    public default Map<String, String> getStoredValues(String storeName) {
        return getBdfServer().getStoredValues(getBdfUser(), storeName);
    }

}
