/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.lexie;

import net.mapeadores.util.text.lexie.LexieParseHandler;

public final class LexieParser {
    private final LexieParseHandler handler;
    private int wordStart = -1;
    private int bufLength = 0;
    private char[] bufArray;

    private LexieParser(LexieParseHandler handler) {
        this.handler = handler;
    }

    public static void parse(String chaine, LexieParseHandler handler) {
        if (chaine == null) {
            return;
        }
        LexieParser lexieParser = new LexieParser(handler);
        lexieParser.parse(chaine);
    }

    private static boolean isLexieCarac(char carac) {
        if (Character.isLetterOrDigit(carac)) {
            return true;
        }
        switch (Character.getType(carac)) {
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private void parse(String chaine) {
        int taille = chaine.length();
        this.bufArray = new char[taille];
        for (int i = 0; i < taille; ++i) {
            char carac = chaine.charAt(i);
            if (Character.isIdeographic(carac)) {
                this.flushWord();
                this.wordStart = i;
                this.bufLength = 1;
                this.bufArray[0] = carac;
                this.flushWord();
                continue;
            }
            if (LexieParser.isLexieCarac(carac)) {
                this.bufArray[this.bufLength] = carac;
                ++this.bufLength;
                if (this.wordStart != -1) continue;
                this.wordStart = i;
                continue;
            }
            this.flushWord();
            this.handler.checkSpecialChar(carac);
        }
        this.flushWord();
    }

    private void flushWord() {
        if (this.wordStart > -1) {
            String word = new String(this.bufArray, 0, this.bufLength);
            this.handler.flushLexie(word, this.wordStart);
            this.bufLength = 0;
            this.wordStart = -1;
        }
    }
}

