/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets.handlers;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.servlets.ResponseHandler;

public class HtmlResponseHandler
implements ResponseHandler {
    private final HtmlProducer htmlProducer;
    private Instant lastModified = ResponseHandler.LASTMODIFIED_NOCACHE;

    public HtmlResponseHandler(HtmlProducer htmlProducer) {
        this.htmlProducer = htmlProducer;
    }

    @Override
    public Instant getLastModified() {
        return this.lastModified;
    }

    public HtmlResponseHandler lastModified(Instant lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Override
    public void handleResponse(HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        try (PrintWriter pw = response.getWriter();){
            this.htmlProducer.writeHtml(pw);
        }
    }

    public static HtmlResponseHandler init(HtmlProducer htmlProducer) {
        return new HtmlResponseHandler(htmlProducer);
    }
}

