/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import net.mapeadores.util.primitives.CodeArray;

public class CodeArrayBuilder<E> {
    private Object[] array;
    private int size = 0;

    public CodeArrayBuilder(int startLength) {
        this.array = new Object[startLength];
    }

    public void put(Integer code, E value) {
        int index = code - 1;
        if (index >= this.array.length) {
            Object[] temp = new Object[index * 2];
            System.arraycopy(this.array, 0, temp, 0, this.size);
            this.array = temp;
        }
        this.array[index] = value;
        this.size = Math.max(this.size, index + 1);
    }

    public void copy(Integer originCode, Integer destinationCode) {
        Object originValue = this.array[originCode - 1];
        this.put(destinationCode, originValue);
    }

    public E get(Integer code) {
        int index = code - 1;
        if (index < 0 || index >= this.array.length) {
            return null;
        }
        return (E)this.array[index];
    }

    public Object[] toArray() {
        Object[] finalArray = new Object[this.size];
        System.arraycopy(this.array, 0, finalArray, 0, this.size);
        return finalArray;
    }

    public CodeArray<E> toCodeArray() {
        return new CodeArray(this.toArray());
    }
}

