/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.format.FormatStyle;
import java.util.Locale;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.EmailItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.LinkItem;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.IrefConverter;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.SphereUtils;
import net.fichotheque.xml.extraction.ExtractOptions;
import net.fichotheque.xml.extraction.FicheBlockXMLPart;
import net.fichotheque.xml.extraction.TagNames;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.date.FuzzyDateFormatter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.SpecialCodes;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.primitives.DegreSexagesimal;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class FicheItemXMLPart
extends XMLPart {
    private final ExtractParameters extractParameters;
    private final FicheBlockXMLPart ficheBlockXMLPart;
    private final ExtractionContext extractionContext;
    private final int extractVersion;
    private final TagNames tagNames;

    public FicheItemXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractParameters = extractParameters;
        this.extractionContext = extractParameters.getExtractionContext();
        this.extractVersion = extractParameters.getExtractVersion();
        this.ficheBlockXMLPart = new FicheBlockXMLPart(xmlWriter, extractParameters);
        this.tagNames = new TagNames(this.extractVersion);
    }

    public void addFicheItems(FicheItems ficheItems, ExtractOptions extractOptions, IrefConverter irefConverter) throws IOException {
        int size = ficheItems.size();
        for (int i = 0; i < size; ++i) {
            this.addFicheItem((FicheItem)ficheItems.get(i), extractOptions, irefConverter);
        }
    }

    public void addFicheItem(FicheItem ficheItem, ExtractOptions extractOptions, IrefConverter irefConverter) throws IOException {
        if (ficheItem instanceof Item) {
            this.addItem((Item)ficheItem);
        } else if (ficheItem instanceof PersonItem) {
            this.addPerson((PersonItem)ficheItem);
        } else if (ficheItem instanceof DateItem) {
            this.addDate((DateItem)ficheItem, extractOptions);
        } else if (ficheItem instanceof LanguageItem) {
            this.addLanguage((LanguageItem)ficheItem);
        } else if (ficheItem instanceof CountryItem) {
            this.addCountry((CountryItem)ficheItem);
        } else if (ficheItem instanceof LinkItem) {
            this.addLink((LinkItem)ficheItem, extractOptions);
        } else if (ficheItem instanceof EmailItem) {
            this.addEmail((EmailItem)ficheItem);
        } else if (ficheItem instanceof AmountItem) {
            this.addAmount((AmountItem)ficheItem, extractOptions);
        } else if (ficheItem instanceof NumberItem) {
            this.addNumber((NumberItem)ficheItem);
        } else if (ficheItem instanceof GeopointItem) {
            this.addGeopoint((GeopointItem)ficheItem);
        } else if (ficheItem instanceof ParaItem) {
            this.addPara((ParaItem)ficheItem, irefConverter);
        } else if (ficheItem instanceof ImageItem) {
            this.addImage((ImageItem)ficheItem, extractOptions);
        } else {
            throw new ClassCastException("unknown instance of FicheItem = " + ficheItem.getClass().getName());
        }
    }

    public void addItem(Item item) throws IOException {
        this.addSimpleElement("item", item.getValue());
    }

    public void addEmail(EmailItem emailItem) throws IOException {
        String emailTagName = this.tagNames.getEmailTagName();
        EmailCore emailCore = emailItem.getEmailCore();
        String addrSpec = emailCore.getAddrSpec();
        this.startOpenTag(emailTagName);
        this.addAttribute("addr-spec", addrSpec);
        String realName = emailCore.getRealName();
        if (realName.length() > 0) {
            this.addAttribute("real-name", realName);
        }
        int idx = addrSpec.indexOf(64);
        this.addAttribute("user", addrSpec.substring(0, idx));
        this.addAttribute("domain", addrSpec.substring(idx + 1));
        this.endOpenTag();
        this.addText(emailItem.toString());
        this.closeTag(emailTagName, false);
    }

    public void addDate(DateItem dateItem, ExtractOptions extractOptions) throws IOException {
        String dateTagName = this.tagNames.getDateTagName();
        FuzzyDate date = dateItem.getDate();
        this.startOpenTag(dateTagName);
        if (this.extractVersion == 1) {
            this.addAttribute("a", String.valueOf(date.getYear()));
            switch (date.getDateType()) {
                case "halfyear": {
                    this.addAttribute("type", "s");
                    this.addAttribute("s", String.valueOf(date.getHalfYear()));
                    break;
                }
                case "quarter": {
                    this.addAttribute("type", "t");
                    this.addAttribute("t", String.valueOf(date.getQuarter()));
                    break;
                }
                case "month": {
                    this.addAttribute("type", "m");
                    this.addAttribute("m", String.valueOf(date.getMonth()));
                    break;
                }
                case "day": {
                    this.addAttribute("type", "j");
                    this.addAttribute("m", String.valueOf(date.getMonth()));
                    this.addAttribute("j", String.valueOf(date.getDay()));
                    break;
                }
                default: {
                    this.addAttribute("type", "a");
                    break;
                }
            }
        } else {
            this.addAttribute("y", String.valueOf(date.getYear()));
            switch (date.getDateType()) {
                case "halfyear": {
                    this.addAttribute("type", "s");
                    this.addAttribute("s", String.valueOf(date.getHalfYear()));
                    break;
                }
                case "quarter": {
                    this.addAttribute("type", "q");
                    this.addAttribute("q", String.valueOf(date.getQuarter()));
                    break;
                }
                case "month": {
                    this.addAttribute("type", "m");
                    this.addAttribute("m", String.valueOf(date.getMonth()));
                    break;
                }
                case "day": {
                    this.addAttribute("type", "d");
                    this.addAttribute("m", String.valueOf(date.getMonth()));
                    this.addAttribute("d", String.valueOf(date.getDay()));
                    break;
                }
                default: {
                    this.addAttribute("type", "y");
                }
            }
        }
        this.addAttribute("iso", date.toISOString());
        this.addAttribute("sort", date.toSortString());
        this.endOpenTag();
        this.addDateLabels(dateItem.getDate(), extractOptions);
        this.closeTag(dateTagName);
    }

    private void addDateLabels(FuzzyDate date, ExtractOptions extractOptions) throws IOException {
        LangContext langContext;
        FormatStyle formatStyle = null;
        if (extractOptions != null && extractOptions instanceof ExtractOptions.Date) {
            ExtractOptions.Date dateOptions = (ExtractOptions.Date)extractOptions;
            String truncateDateType = dateOptions.getTruncateDateType();
            if (truncateDateType != null) {
                date = date.truncate(truncateDateType);
            }
            formatStyle = dateOptions.getStyle();
        }
        if (formatStyle == null) {
            formatStyle = FormatStyle.LONG;
        }
        if ((langContext = this.extractionContext.getLangContext()) instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                Locale formatLocale = unit.getFormatLocale();
                FuzzyDateFormatter fuzzyDateFormatter = FuzzyDateFormatter.build(formatStyle, formatLocale);
                LabelUtils.addLabel(this, lang, fuzzyDateFormatter.format(date));
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            FuzzyDateFormatter fuzzyDateFormatter = FuzzyDateFormatter.build(formatStyle, userLangContext.getFormatLocale());
            LabelUtils.addLabel(this, null, fuzzyDateFormatter.format(date));
        }
    }

    public void addLanguage(LanguageItem language) throws IOException {
        String languageTagName = this.tagNames.getLanguageTagName();
        String code = language.getLang().toString();
        this.startOpenTag(languageTagName);
        this.addAttribute("lang", code);
        this.endOpenTag();
        this.addLangLabels(code);
        this.closeTag(languageTagName);
    }

    private void addLangLabels(String code) throws IOException {
        LangContext langContext = this.extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(lang).toString(code);
                if (message == null) continue;
                message = StringUtils.getFirstPart(message);
                LabelUtils.addLabel(this, lang, message);
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(userLangContext).toString(code);
            if (message != null) {
                message = StringUtils.getFirstPart(message);
                LabelUtils.addLabel(this, null, message);
            }
        }
    }

    public void addNumber(NumberItem numberItem) throws IOException {
        String numberTagName = this.tagNames.getNumberTagName();
        this.startOpenTag(numberTagName);
        Decimal decimal = numberItem.getDecimal();
        this.addDecimalAttributes(decimal);
        this.endOpenTag();
        this.addNumberLabels(decimal);
        this.closeTag(numberTagName);
    }

    public void addGeopoint(GeopointItem geopoint) throws IOException {
        this.startOpenTag("geopoint");
        DegreDecimal latitude = geopoint.getLatitude();
        DegreDecimal longitude = geopoint.getLongitude();
        this.addAttribute("lat", latitude.toString());
        this.addAttribute("lon", longitude.toString());
        this.endOpenTag();
        DegreSexagesimal latitudeSexa = DegreSexagesimal.fromDegreDecimal(latitude);
        DegreSexagesimal longitudeSexa = DegreSexagesimal.fromDegreDecimal(longitude);
        this.startOpenTag("latitude");
        this.addSexagesimalAttributes(latitudeSexa);
        this.endOpenTag();
        this.addSexagesimalLabels(latitudeSexa, true);
        this.closeTag("latitude");
        this.startOpenTag("longitude");
        this.addSexagesimalAttributes(longitudeSexa);
        this.endOpenTag();
        this.addSexagesimalLabels(longitudeSexa, false);
        this.closeTag("longitude");
        this.closeTag("geopoint");
    }

    private void addSexagesimalAttributes(DegreSexagesimal sexa) throws IOException {
        this.addAttribute("deg", sexa.getDegre());
        this.addAttribute("mn", sexa.getMinute());
        this.addAttribute("sec", sexa.getSeconde());
    }

    private void addSexagesimalLabels(DegreSexagesimal sexa, boolean latitude) throws IOException {
        String code = latitude ? SpecialCodes.getLatitudeSpecialCode(sexa) : SpecialCodes.getLongitudeSpecialCode(sexa);
        LangContext langContext = this.extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                StringBuilder buf = new StringBuilder();
                buf.append(sexa.toString(false, " "));
                buf.append(" ");
                String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(lang).toString(code);
                if (message != null) {
                    buf.append(message);
                } else {
                    buf.append(code);
                }
                LabelUtils.addLabel(this, lang, buf.toString());
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            StringBuilder buf = new StringBuilder();
            buf.append(sexa.toString(false, " "));
            buf.append(" ");
            String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(userLangContext).toString(code);
            if (message != null) {
                buf.append(message);
            } else {
                buf.append(code);
            }
            LabelUtils.addLabel(this, null, buf.toString());
        }
    }

    private void addNumberLabels(Decimal decimal) throws IOException {
        LangContext langContext = this.extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                Locale formatLocale = unit.getFormatLocale();
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(formatLocale);
                String strg = decimal.toString(symbols);
                LabelUtils.addLabel(this, lang, strg);
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            Locale formatLocale = userLangContext.getFormatLocale();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(formatLocale);
            String strg = decimal.toString(symbols);
            LabelUtils.addLabel(this, null, strg);
        }
    }

    public void addAmount(AmountItem amountItem, ExtractOptions extractOptions) throws IOException {
        String amountTagName = this.tagNames.getAmountTagName();
        this.startOpenTag(amountTagName);
        Decimal decimal = amountItem.getDecimal();
        this.addDecimalAttributes(decimal);
        this.addAttribute("cur", amountItem.getCurrency().getCurrencyCode());
        this.addAttribute("money-long", String.valueOf(amountItem.toMoneyLong()));
        this.endOpenTag();
        this.addAmountLabels(decimal, amountItem.getCurrency(), amountItem.toMoneyLong(), extractOptions);
        this.closeTag(amountTagName);
    }

    private void addAmountLabels(Decimal decimal, ExtendedCurrency currency, long moneyLong, ExtractOptions extractOptions) throws IOException {
        LangContext langContext;
        boolean forceSubunit = false;
        if (extractOptions != null && extractOptions instanceof ExtractOptions.Amount) {
            ExtractOptions.Amount amountOptions = (ExtractOptions.Amount)extractOptions;
            forceSubunit = amountOptions.isForceSubunit();
        }
        if ((langContext = this.extractionContext.getLangContext()) instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                Locale formatLocale = unit.getFormatLocale();
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(formatLocale);
                String strg = forceSubunit ? MoneyUtils.toLitteralString(moneyLong, currency, symbols, false) : MoneyUtils.toLitteralString(decimal, currency, symbols);
                LabelUtils.addLabel(this, lang, strg);
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            Locale formatLocale = userLangContext.getFormatLocale();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(formatLocale);
            String strg = forceSubunit ? MoneyUtils.toLitteralString(moneyLong, currency, symbols, false) : MoneyUtils.toLitteralString(decimal, currency, symbols);
            LabelUtils.addLabel(this, null, strg);
        }
    }

    private void addDecimalAttributes(Decimal decimal) throws IOException {
        String partieEntiere = decimal.getPartieEntiereString();
        String partieDecimale = decimal.getPartieDecimaleString();
        this.addAttribute("int", partieEntiere);
        this.addAttribute("dec", partieDecimale);
        String val = partieDecimale.length() != 0 ? partieEntiere + "." + partieDecimale : partieEntiere;
        this.addAttribute("val", val);
    }

    public void addLink(LinkItem link, ExtractOptions extractOptions) throws IOException {
        this.startOpenTag("link");
        this.addAttribute("href", link.getHref());
        this.checkBaseUrl(extractOptions, link.getHref());
        this.endOpenTag();
        String title = link.getTitle();
        if (title.length() == 0) {
            title = link.getHref();
            if (title.startsWith("http://") && title.length() > 8) {
                title = title.substring(7);
            } else if (title.startsWith("https://") && title.length() > 9) {
                title = title.substring(8);
            }
        }
        this.addSimpleElement("title", title);
        this.addSimpleElement("comment", link.getComment());
        this.closeTag("link");
    }

    public void addImage(ImageItem image, ExtractOptions extractOptions) throws IOException {
        this.startOpenTag("image");
        this.addAttribute("src", image.getSrc());
        this.checkBaseUrl(extractOptions, image.getSrc());
        this.endOpenTag();
        this.addSimpleElement("alt", image.getAlt());
        this.addSimpleElement("title", image.getTitle());
        this.closeTag("image");
    }

    private void checkBaseUrl(ExtractOptions extractOptions, String ref) throws IOException {
        ExtractOptions.Ref refOptions;
        String baseUrl;
        if (extractOptions != null && extractOptions instanceof ExtractOptions.Ref && (baseUrl = (refOptions = (ExtractOptions.Ref)extractOptions).getBaseUrl()) != null && !StringUtils.isAbsoluteUrlString(ref)) {
            this.addAttribute("base-url", baseUrl);
        }
    }

    public void addCountry(CountryItem countryItem) throws IOException {
        String countryTagName = this.tagNames.getCountryTagName();
        this.startOpenTag(countryTagName);
        this.addAttribute("country", countryItem.getCountry().toString());
        this.endOpenTag();
        this.addCountryLabels(countryItem.getCountry().toString());
        this.closeTag(countryTagName);
    }

    private void addCountryLabels(String countryCode) throws IOException {
        LangContext langContext = this.extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(lang).toString(countryCode);
                if (message == null) continue;
                message = StringUtils.getFirstPart(message);
                LabelUtils.addLabel(this, lang, message);
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(userLangContext).toString(countryCode);
            if (message != null) {
                message = StringUtils.getFirstPart(message);
                LabelUtils.addLabel(this, null, message);
            }
        }
    }

    public void addPerson(PersonItem personItem) throws IOException {
        block7: {
            String personTagName = this.tagNames.getPersonTagName();
            this.startOpenTag(personTagName);
            String redacteurGlobalId = personItem.getRedacteurGlobalId();
            if (redacteurGlobalId != null) {
                try {
                    SubsetKey sphereKey = SphereUtils.getSubsetKey(redacteurGlobalId);
                    int id = SphereUtils.getId(redacteurGlobalId);
                    this.addAttribute("sphere", sphereKey.getSubsetName());
                    this.addAttribute("id", String.valueOf(id));
                    Redacteur redacteur = null;
                    Sphere sphere = (Sphere)this.extractionContext.getFichotheque().getSubset(sphereKey);
                    if (sphere != null) {
                        redacteur = sphere.getRedacteurById(id);
                    }
                    if (redacteur != null) {
                        this.addAttribute("login", redacteur.getLogin());
                        this.endOpenTag();
                        this.addPersonCore(redacteur.getPersonCore());
                        this.closeTag(personTagName);
                        break block7;
                    }
                    this.closeEmptyTag();
                }
                catch (ParseException pe) {
                    this.closeEmptyTag();
                }
            } else {
                this.endOpenTag();
                this.addPersonCore(personItem.getPersonCore());
                this.addSimpleElement("organism", personItem.getOrganism());
                if (this.extractVersion == 1) {
                    this.addSimpleElement("organisme", personItem.getOrganism());
                }
                this.closeTag(personTagName);
            }
        }
    }

    private void addPersonCore(PersonCore personCore) throws IOException {
        String surname = personCore.getSurname();
        boolean surnameFirst = personCore.isSurnameFirst();
        if (surname.length() > 0) {
            this.startOpenTag("surname");
            if (surnameFirst) {
                this.addAttribute("surname-first", "true");
            }
            this.endOpenTag();
            this.addText(surname);
            this.closeTag("surname", false);
        }
        this.addSimpleElement("forename", personCore.getForename());
        this.addSimpleElement("nonlatin", personCore.getNonlatin());
        if (this.extractVersion == 1) {
            if (surname.length() > 0) {
                this.startOpenTag("nom");
                if (surnameFirst) {
                    this.addAttribute("avant", "true");
                }
                this.endOpenTag();
                this.addText(surname);
                this.closeTag("nom", false);
            }
            this.addSimpleElement("prenom", personCore.getForename());
            this.addSimpleElement("original", personCore.getNonlatin());
        }
    }

    public void addPara(ParaItem para, IrefConverter irefConverter) throws IOException {
        this.startOpenTag("para");
        this.endOpenTag();
        this.ficheBlockXMLPart.addTextContent(para, irefConverter);
        this.closeTag("para", false);
    }
}

