/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import net.fichotheque.selection.RedacteurQuery;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextTestEngine;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.models.PersonCore;

class RedacteurSelectEngine {
    private final short conditionType;
    private final TextTestEngine textTestEngine;

    RedacteurSelectEngine(RedacteurQuery redacteurQuery, SelectionContext selectionContext) {
        TextCondition nameCondition = redacteurQuery.getNomcompletCondition();
        if (nameCondition != null) {
            this.conditionType = ConditionsUtils.getConditionType(nameCondition);
            this.textTestEngine = ConditionsUtils.isPartialState(this.conditionType) ? TextTestEngine.newInstance(nameCondition, selectionContext.getWorkingLang()) : null;
        } else {
            this.conditionType = 0;
            this.textTestEngine = null;
        }
    }

    boolean isSelected(Redacteur redacteur) {
        return this.conditionType == 0 || this.isCompletenameSelected(redacteur);
    }

    private boolean isCompletenameSelected(Redacteur redacteur) {
        switch (this.conditionType) {
            case 2: {
                return false;
            }
            case 0: 
            case 1: {
                return true;
            }
            case 4: {
                return this.isNotEmpty(redacteur);
            }
            case 3: {
                return !this.isNotEmpty(redacteur);
            }
            case 5: 
            case 6: {
                return this.textTestEngine.isSelected(redacteur.getCompleteName());
            }
        }
        throw new SwitchException("state = " + this.conditionType);
    }

    private boolean isNotEmpty(Redacteur redacteur) {
        PersonCore personCore = redacteur.getPersonCore();
        return personCore.getSurname().length() != 0 || personCore.getForename().length() != 0 || personCore.getNonlatin().length() != 0;
    }
}

