/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.permission;

import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.permission.PermissionSummary;

public class PermissionPredicate
implements Predicate<SubsetItem> {
    private final PermissionSummary permissionSummary;
    private final boolean read;

    private PermissionPredicate(PermissionSummary permissionSummary, boolean read) {
        this.permissionSummary = permissionSummary;
        this.read = read;
    }

    @Override
    public boolean test(SubsetItem subsetItem) {
        if (this.read) {
            return this.permissionSummary.canRead(subsetItem);
        }
        return this.permissionSummary.canWrite(subsetItem);
    }

    public static PermissionPredicate read(PermissionSummary permissionSummary) {
        return new PermissionPredicate(permissionSummary, true);
    }

    public static PermissionPredicate write(PermissionSummary permissionSummary) {
        return new PermissionPredicate(permissionSummary, false);
    }
}

