/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.junction;

import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.parsers.junction.TieToken;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;

public class WeightMotcleToken {
    private final boolean idBundle;
    private int weight = 1;
    private int id;
    private CleanedString text;

    private WeightMotcleToken(int id, int weight) {
        this.id = id;
        this.weight = weight;
        this.idBundle = true;
    }

    private WeightMotcleToken(CleanedString text, int weight) {
        this.text = CleanedString.newInstance(text);
        this.weight = weight;
        this.idBundle = false;
    }

    public static WeightMotcleToken parse(String s, boolean withIdalpha, int weightFilter) {
        CleanedString cleanedString;
        TieToken tieToken = TieToken.parse(s);
        String text = tieToken.getText();
        int weight = weightFilter < 1 ? tieToken.getWeight() : weightFilter;
        if (!withIdalpha) {
            try {
                int id = Integer.parseInt(text);
                return new WeightMotcleToken(id, weight);
            }
            catch (NumberFormatException id) {
                // empty catch block
            }
        }
        if (text.startsWith("=")) {
            try {
                int id = Integer.parseInt(text.substring(1).trim());
                return new WeightMotcleToken(id, weight);
            }
            catch (NumberFormatException id) {
                // empty catch block
            }
        }
        if ((cleanedString = CleanedString.newInstance(text)) == null) {
            return null;
        }
        return new WeightMotcleToken(cleanedString, weight);
    }

    public boolean isIdBundle() {
        return this.idBundle;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getId() {
        return this.id;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public CleanedString getText() {
        return this.text;
    }

    public static Motcle getMotcle(WeightMotcleToken motcleToken, Thesaurus thesaurus, Lang lang) {
        if (motcleToken.isIdBundle()) {
            return thesaurus.getMotcleById(motcleToken.getId());
        }
        CleanedString cleanedString = motcleToken.getText();
        if (cleanedString == null) {
            return null;
        }
        String text = cleanedString.toString();
        if (thesaurus.isIdalphaType()) {
            return thesaurus.getMotcleByIdalpha(text);
        }
        return thesaurus.seekMotcleByLabel(text, lang);
    }
}

