/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.syntaxes;

import net.fichotheque.tools.extraction.syntaxes.AbstractStepResolver;

public class CssPropertyResolver
extends AbstractStepResolver {
    private static final short ERROR_STEP = 0;
    private static final short NAME_STEP = 1;
    private static final short VALUE_STEP = 2;
    private static final short VALUE_NUMBER_STEP = 3;
    private static final short ONQUOTE_STEP = 5;
    private static final short WAITING_NAME_STEP = 11;
    private static final short WAITING_OPERATOR_STEP = 12;
    private static final short WAITING_VALUE_STEP = 13;
    private int step = 11;
    private char currentQuote;

    private CssPropertyResolver() {
    }

    @Override
    public void resolveChar(char carac) {
        switch (carac) {
            case ' ': {
                this.resolveSpace();
                break;
            }
            case ';': {
                this.resolveDelimiter();
                break;
            }
            case ':': {
                this.resolveOperator();
                break;
            }
            default: {
                this.appendChar(carac);
            }
        }
    }

    @Override
    public String getStepClassName(String textPart, boolean lastPart) {
        switch (this.step) {
            case 1: {
                return "cm-property";
            }
            case 2: {
                return "cm-atom";
            }
            case 3: {
                return "cm-number";
            }
            case 0: {
                return "cm-error";
            }
            case 5: {
                return "cm-string";
            }
        }
        return null;
    }

    private void resolveSpace() {
        boolean appendToCurrent = false;
        switch (this.step) {
            case 0: 
            case 5: {
                appendToCurrent = true;
                break;
            }
            case 2: 
            case 3: {
                this.flush();
                this.step = 13;
                break;
            }
            case 1: {
                this.flush();
                this.step = 12;
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent(' ');
        } else {
            this.appendSpaceToFinal();
        }
    }

    private void resolveDelimiter() {
        switch (this.step) {
            case 5: {
                this.appendToCurrent(';');
                break;
            }
            default: {
                this.flush();
                this.appendToFinal("cm-punctuation", ";");
                this.step = 11;
            }
        }
    }

    private void resolveOperator() {
        switch (this.step) {
            case 0: 
            case 5: {
                this.appendToCurrent(':');
                break;
            }
            case 1: 
            case 12: {
                this.flush();
                this.appendOperator(":");
                this.step = 13;
                break;
            }
            default: {
                this.flush();
                this.appendToCurrent(':');
                this.step = 0;
            }
        }
    }

    private void appendChar(char carac) {
        boolean appendToCurrent = true;
        block0 : switch (this.step) {
            case 11: {
                this.step = 1;
                break;
            }
            case 12: {
                this.flush();
                this.step = 0;
                break;
            }
            case 13: {
                this.flush();
                switch (carac) {
                    case '\"': 
                    case '\'': {
                        this.currentQuote = carac;
                        this.step = 5;
                        break block0;
                    }
                }
                if (Character.isDigit(carac)) {
                    this.step = 3;
                    break;
                }
                this.step = 2;
                break;
            }
            case 5: {
                if (carac != this.currentQuote) break;
                this.appendToCurrent(carac);
                this.flush();
                this.step = 13;
                appendToCurrent = false;
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent(carac);
        }
    }

    public static String resolve(String value) {
        if (value.isEmpty()) {
            return "";
        }
        CssPropertyResolver resolver = new CssPropertyResolver();
        resolver.resolveText(value);
        return resolver.end();
    }
}

