/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateDef;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.utils.TransformationUtils;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MessageHandler;

public class TemplateDescriptionBuilder {
    private static final List<TemplateContentDescription> EMPTY_CONTENTLIST = Collections.emptyList();
    private final InternalMessageHandler messageHandler = new InternalMessageHandler();
    private final TemplateDef templateDef;
    private final String type;
    private final List<Message> errorList = new ArrayList<Message>();
    private final List<Message> warningList = new ArrayList<Message>();
    private final List<TemplateContentDescription> templateContentDescriptionList = new ArrayList<TemplateContentDescription>();

    public TemplateDescriptionBuilder(TemplateDef templateDef, String type) {
        if (templateDef == null) {
            throw new IllegalArgumentException("templateDef is null");
        }
        if (templateDef.getTemplateKey().isDist()) {
            throw new IllegalArgumentException("templateDef.getTemplateKey() is dist key");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.templateDef = templateDef;
        this.type = type;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public TemplateDescriptionBuilder addTemplateContentDescription(TemplateContentDescription templateContentDescription) {
        this.templateContentDescriptionList.add(templateContentDescription);
        return this;
    }

    public TemplateDescriptionBuilder addAll(List<TemplateContentDescription> list) {
        this.templateContentDescriptionList.addAll(list);
        return this;
    }

    public TemplateDescription toTemplateDescription() {
        String state = this.checkState();
        List<Message> finalErrorList = LocalisationUtils.wrap(this.errorList.toArray(new Message[this.errorList.size()]));
        List<Message> finalWarningList = LocalisationUtils.wrap(this.warningList.toArray(new Message[this.warningList.size()]));
        List<TemplateContentDescription> finalTemplateContentDescriptionList = TransformationUtils.wrap(this.templateContentDescriptionList.toArray(new TemplateContentDescription[this.templateContentDescriptionList.size()]));
        return new InternalTemplateDescription(this.templateDef, this.type, state, finalErrorList, finalWarningList, finalTemplateContentDescriptionList);
    }

    private String checkState() {
        if (!this.errorList.isEmpty()) {
            return "error";
        }
        boolean withWarning = !this.warningList.isEmpty();
        for (TemplateContentDescription templateContentDescription : this.templateContentDescriptionList) {
            String contentState = templateContentDescription.getState();
            if (contentState.equals("ok")) continue;
            if (templateContentDescription.isMandatory()) {
                return "error";
            }
            withWarning = true;
        }
        if (withWarning) {
            return "with_warnings";
        }
        return "ok";
    }

    public static TemplateDescriptionBuilder init(TemplateDef templateDef, String type) {
        return new TemplateDescriptionBuilder(templateDef, type);
    }

    public static TemplateDescription buildUnknownType(TemplateDef templateDef, String type) {
        List<Message> errorList = Collections.singletonList(LocalisationUtils.toMessage("_ error.unknown.transformation.templatetype", type));
        return new InternalTemplateDescription(templateDef, type, "unknown_template_type", errorList, LocalisationUtils.EMPTY_MESSAGELIST, EMPTY_CONTENTLIST);
    }

    private class InternalMessageHandler
    implements MessageHandler {
        private InternalMessageHandler() {
        }

        @Override
        public void addMessage(String category, Message message) {
            if (category.contains("warning")) {
                TemplateDescriptionBuilder.this.warningList.add(message);
            } else {
                TemplateDescriptionBuilder.this.errorList.add(message);
            }
        }
    }

    private static class InternalTemplateDescription
    implements TemplateDescription {
        private final TemplateDef templateDef;
        private final String type;
        private final String state;
        private final List<Message> errorList;
        private final List<Message> warningList;
        private final List<TemplateContentDescription> templateContentDescriptionList;

        private InternalTemplateDescription(TemplateDef templateDef, String type, String state, List<Message> errorList, List<Message> warningList, List<TemplateContentDescription> templateContentDescriptionList) {
            this.templateDef = templateDef;
            this.type = type;
            this.state = state;
            this.errorList = errorList;
            this.warningList = warningList;
            this.templateContentDescriptionList = templateContentDescriptionList;
        }

        @Override
        public TemplateDef getTemplateDef() {
            return this.templateDef;
        }

        @Override
        public String getState() {
            return this.state;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public List<Message> getErrorMessageList() {
            return this.errorList;
        }

        @Override
        public List<Message> getWarningMessageList() {
            return this.warningList;
        }

        @Override
        public List<TemplateContentDescription> getTemplateContentDescriptionList() {
            return this.templateContentDescriptionList;
        }
    }
}

