/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.synthesis;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.tools.synthesis.RedacteurSynthesis;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;

public class SphereSynthesis {
    private final SubsetKey sphereKey;
    private final SortedMap<String, Sphere> sphereMap = new TreeMap<String, Sphere>();
    private final SortedMap<String, RedacteurSynthesis> redacteurMap = new TreeMap<String, RedacteurSynthesis>();
    private final LabelOccurrenceManager labelOccurrenceManager = new LabelOccurrenceManager();

    public SphereSynthesis(SubsetKey sphereKey) {
        this.sphereKey = sphereKey;
    }

    public String getSphereName() {
        return this.sphereKey.getSubsetName();
    }

    public SubsetKey getSphereKey() {
        return this.sphereKey;
    }

    public boolean isInFichotheque(String fichothequeName) {
        return this.sphereMap.containsKey(fichothequeName);
    }

    public void addSphere(BdfServer bdfServer, Sphere sphere) {
        String fichothequeName = bdfServer.getName();
        PermissionManager permissionManager = bdfServer.getPermissionManager();
        this.sphereMap.put(fichothequeName, sphere);
        for (Redacteur redacteur : sphere.getRedacteurList()) {
            String login = redacteur.getLogin();
            RedacteurSynthesis synthesis = (RedacteurSynthesis)this.redacteurMap.get(login);
            if (synthesis == null) {
                synthesis = new RedacteurSynthesis(login);
                this.redacteurMap.put(login, synthesis);
            }
            boolean admin = permissionManager.isAdmin(redacteur);
            synthesis.addRedacteur(redacteur, fichothequeName, admin);
        }
        this.labelOccurrenceManager.checkSphere(sphere, fichothequeName);
    }

    public int getFichothequeSize() {
        return this.sphereMap.size();
    }

    public Sphere getSphere(String fichothequeName) {
        return (Sphere)this.sphereMap.get(fichothequeName);
    }

    public String[] getFichothequeNameArray() {
        return this.sphereMap.keySet().toArray(new String[this.sphereMap.size()]);
    }

    public RedacteurSynthesis[] getRedacteurSynthesisArray() {
        return this.redacteurMap.values().toArray(new RedacteurSynthesis[this.redacteurMap.size()]);
    }

    public RedacteurSynthesis getRedacteurSynthesis(String login) {
        return (RedacteurSynthesis)this.redacteurMap.get(login);
    }

    public Labels getLabels() {
        return this.labelOccurrenceManager;
    }

    public SpecificInfo getSpecificInfo(String fichothequeName) {
        return this.labelOccurrenceManager.getSpecificInfo(fichothequeName);
    }

    private static class LabelOccurrenceManager
    extends AbstractList<Label>
    implements Labels {
        private final Map<Lang, LabelOccurrenceMap> byLangMap = new HashMap<Lang, LabelOccurrenceMap>();
        private final List<LabelOccurrenceMap> list = new ArrayList<LabelOccurrenceMap>();

        private LabelOccurrenceManager() {
        }

        private void checkSphere(Sphere sphere, String fichothequeName) {
            for (Label label : sphere.getSphereMetadata().getTitleLabels()) {
                Lang lang = label.getLang();
                LabelOccurrenceMap occurrenceMap = this.byLangMap.get(lang);
                if (occurrenceMap == null) {
                    occurrenceMap = new LabelOccurrenceMap(lang);
                    this.byLangMap.put(lang, occurrenceMap);
                    this.list.add(occurrenceMap);
                }
                occurrenceMap.add(fichothequeName, label.getLabelString());
            }
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Label get(int index) {
            return this.list.get(index);
        }

        @Override
        public Label getLabel(Lang lang) {
            return this.byLangMap.get(lang);
        }

        private SpecificInfo getSpecificInfo(String fichothequeName) {
            ArrayList<LabelOccurrence> labelList = new ArrayList<LabelOccurrence>();
            for (LabelOccurrenceMap map : this.list) {
                LabelOccurrence labelOccurrence;
                if (map.isInMax(fichothequeName) || (labelOccurrence = map.getLabelOccurrence(fichothequeName)) == null) continue;
                labelList.add(labelOccurrence);
            }
            if (!labelList.isEmpty()) {
                return new SpecificInfo(labelList);
            }
            return null;
        }
    }

    public static class SpecificInfo {
        private final List<Label> labelList;

        private SpecificInfo(List<Label> labelList) {
            this.labelList = labelList;
        }

        public List<Label> getLabelList() {
            return this.labelList;
        }
    }

    private static class LabelOccurrence
    implements Label {
        private final Lang lang;
        private final String labelString;
        private final Set<String> fichothequeNameSet = new HashSet<String>();

        private LabelOccurrence(Lang lang, String labelString) {
            this.lang = lang;
            this.labelString = labelString;
        }

        @Override
        public Lang getLang() {
            return this.lang;
        }

        @Override
        public String getLabelString() {
            return this.labelString;
        }

        private void add(String fichothequeName) {
            this.fichothequeNameSet.add(fichothequeName);
        }

        private int size() {
            return this.fichothequeNameSet.size();
        }

        private boolean contains(String fichothequeName) {
            return this.fichothequeNameSet.contains(fichothequeName);
        }
    }

    private static class LabelOccurrenceMap
    implements Label {
        private final Lang lang;
        private final Map<String, LabelOccurrence> map = new LinkedHashMap<String, LabelOccurrence>();
        private LabelOccurrence maxLabelOccurrence;

        private LabelOccurrenceMap(Lang lang) {
            this.lang = lang;
        }

        private void add(String fichothequeName, String labelString) {
            LabelOccurrence labelOccurrence = this.map.get(labelString);
            if (labelOccurrence == null) {
                labelOccurrence = new LabelOccurrence(this.lang, labelString);
                this.map.put(labelString, labelOccurrence);
            }
            labelOccurrence.add(fichothequeName);
            if (this.maxLabelOccurrence == null) {
                this.maxLabelOccurrence = labelOccurrence;
            }
            if (labelOccurrence.size() > this.maxLabelOccurrence.size()) {
                this.maxLabelOccurrence = labelOccurrence;
            }
        }

        @Override
        public Lang getLang() {
            return this.lang;
        }

        @Override
        public String getLabelString() {
            return this.maxLabelOccurrence.getLabelString();
        }

        private boolean isInMax(String fichothequeName) {
            return this.maxLabelOccurrence.contains(fichothequeName);
        }

        private LabelOccurrence getLabelOccurrence(String fichothequeName) {
            for (LabelOccurrence labelOccurrence : this.map.values()) {
                if (!labelOccurrence.contains(fichothequeName)) continue;
                return labelOccurrence;
            }
            return null;
        }
    }
}

