/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.filesupload;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.filesupload.TmpFileGroup;
import fr.exemole.bdfserver.tools.filesupload.TmpFileInfo;
import fr.exemole.bdfserver.tools.filesupload.UploadError;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.List;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.request.FileValue;

public final class FilesUploadUtils {
    private FilesUploadUtils() {
    }

    public static File saveTmpFile(BdfServer bdfServer, FileValue fileValue, String extension) throws IOException {
        File f = FilesUploadUtils.getTmpFile(bdfServer, extension);
        try (InputStream is = fileValue.getInputStream();
             FileOutputStream os = new FileOutputStream(f);){
            IOUtils.copy(is, (OutputStream)os);
        }
        return f;
    }

    public static File getTmpFile(BdfServer bdfServer, String extension) {
        BdfServer bdfServer2 = bdfServer;
        synchronized (bdfServer2) {
            File tmpDirectory = ConfigurationUtils.getTmpDirectory(bdfServer, true);
            String number = Long.toHexString(System.currentTimeMillis());
            File f = new File(tmpDirectory, "doc-" + number + "." + extension);
            if (!f.exists()) {
                return f;
            }
            int p = 1;
            while (true) {
                if (!(f = new File(tmpDirectory, "doc-" + number + "_" + p + "." + extension)).exists()) {
                    return f;
                }
                ++p;
            }
        }
    }

    public static List<TmpFileInfo> wrap(TmpFileInfo[] array) {
        return new TmpFileInfoList(array);
    }

    public static List<TmpFileGroup> wrap(TmpFileGroup[] array) {
        return new TmpFileGroupList(array);
    }

    public static List<UploadError> wrap(UploadError[] array) {
        return new UploadErrorList(array);
    }

    private static class TmpFileInfoList
    extends AbstractList<TmpFileInfo> {
        private final TmpFileInfo[] array;

        private TmpFileInfoList(TmpFileInfo[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TmpFileInfo get(int index) {
            return this.array[index];
        }
    }

    private static class TmpFileGroupList
    extends AbstractList<TmpFileGroup> {
        private final TmpFileGroup[] array;

        private TmpFileGroupList(TmpFileGroup[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TmpFileGroup get(int index) {
            return this.array[index];
        }
    }

    private static class UploadErrorList
    extends AbstractList<UploadError> {
        private final UploadError[] array;

        private UploadErrorList(UploadError[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public UploadError get(int index) {
            return this.array[index];
        }
    }
}

