/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.filesupload;

import fr.exemole.bdfserver.tools.filesupload.TmpFileGroup;
import fr.exemole.bdfserver.tools.filesupload.TmpFileInfo;
import fr.exemole.bdfserver.tools.filesupload.UploadError;
import java.util.List;

public abstract class FilesUploadResult {
    public abstract String getType();

    public static class Multi
    extends FilesUploadResult {
        private final List<TmpFileGroup> groupList;
        private final List<UploadError> uploadErrorList;

        Multi(List<TmpFileGroup> groupList, List<UploadError> uploadErrorList) {
            this.groupList = groupList;
            this.uploadErrorList = uploadErrorList;
        }

        @Override
        public String getType() {
            return "multi";
        }

        public List<TmpFileGroup> getTmpFileGroupList() {
            return this.groupList;
        }

        public List<UploadError> getUploadErrorList() {
            return this.uploadErrorList;
        }
    }

    public static class Unique
    extends FilesUploadResult {
        private final List<TmpFileInfo> list;
        private final List<UploadError> uploadErrorList;

        Unique(List<TmpFileInfo> list, List<UploadError> uploadErrorList) {
            this.list = list;
            this.uploadErrorList = uploadErrorList;
        }

        @Override
        public String getType() {
            return "unique";
        }

        public List<TmpFileInfo> getTmpFileInfoList() {
            return this.list;
        }

        public List<UploadError> getUploadErrorList() {
            return this.uploadErrorList;
        }
    }
}

