/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders.thesaurus;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.include.SubsetItemValue;
import fr.exemole.bdfserver.api.ficheform.include.ThesaurusEntry;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.builders.thesaurus.MotcleValueListBuilder;
import java.util.List;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;

public class NotEditableThesaurusEntryBuilder {
    private final String name;
    private final Thesaurus thesaurus;
    private final MotcleValueListBuilder motcleValueListBuilder = new MotcleValueListBuilder();
    private String label = "";
    private boolean mandatory = false;
    private Attribute idalphaStyle = null;
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;

    public NotEditableThesaurusEntryBuilder(String name, Thesaurus thesaurus) {
        this.name = name;
        this.thesaurus = thesaurus;
    }

    public NotEditableThesaurusEntryBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public NotEditableThesaurusEntryBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public NotEditableThesaurusEntryBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public NotEditableThesaurusEntryBuilder addMotcle(Motcle motcle) {
        this.motcleValueListBuilder.add(motcle, -1);
        return this;
    }

    public NotEditableThesaurusEntryBuilder setIdalphaStyle(Attribute idalphaStyle) {
        this.idalphaStyle = idalphaStyle;
        return this;
    }

    public ThesaurusEntry.NotEditable toNotEditableThesaurusEntry() {
        return new InternalNotEditableThesaurusEntry(this.name, this.label, this.mandatory, this.attributes, this.thesaurus, this.idalphaStyle, this.motcleValueListBuilder.toList());
    }

    public static ThesaurusEntry.NotEditable build(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, SubsetIncludeUi includeUi) {
        NotEditableThesaurusEntryBuilder builder = NotEditableThesaurusEntryBuilder.check(fichePointeur, ficheFormParameters, includeUi);
        if (builder == null) {
            return null;
        }
        return builder.toNotEditableThesaurusEntry();
    }

    @Nullable
    public static NotEditableThesaurusEntryBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, SubsetIncludeUi includeUi) {
        Thesaurus thesaurus = (Thesaurus)ficheFormParameters.getBdfServer().getFichotheque().getSubset(includeUi.getSubsetKey());
        if (thesaurus == null) {
            return null;
        }
        NotEditableThesaurusEntryBuilder builder = NotEditableThesaurusEntryBuilder.init(includeUi.getName(), thesaurus).setIdalphaStyle(FicheFormUtils.getIdalphaStyle(includeUi, thesaurus)).setAttributes(includeUi.getAttributes()).setLabel(L10nUtils.toLabelString(ficheFormParameters, includeUi));
        SubsetItemPointeur pointeur = FicheFormUtils.checkMasterPointeur(fichePointeur, ficheFormParameters, includeUi);
        if (pointeur.isEmpty()) {
            builder.motcleValueListBuilder.populateDefault(ficheFormParameters, includeUi, thesaurus);
        } else {
            builder.motcleValueListBuilder.populate(pointeur.getJunctions(thesaurus), includeUi, false);
        }
        if (builder.motcleValueListBuilder.isEmpty() && includeUi.isObsolete()) {
            return null;
        }
        return builder;
    }

    public static NotEditableThesaurusEntryBuilder init(String name, Thesaurus thesaurus) {
        return new NotEditableThesaurusEntryBuilder(name, thesaurus);
    }

    private static class InternalNotEditableThesaurusEntry
    implements ThesaurusEntry.NotEditable {
        private final String name;
        private final String label;
        private final boolean mandatory;
        private final Attributes attributes;
        private final Thesaurus thesaurus;
        private final Attribute idalphaStyle;
        private final List<SubsetItemValue> list;

        private InternalNotEditableThesaurusEntry(String name, String label, boolean mandatory, Attributes attributes, Thesaurus thesaurus, Attribute idalphaStyle, List<SubsetItemValue> list) {
            this.name = name;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.thesaurus = thesaurus;
            this.idalphaStyle = idalphaStyle;
            this.list = list;
        }

        @Override
        public String getIncludeName() {
            return this.name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public Thesaurus getThesaurus() {
            return this.thesaurus;
        }

        @Override
        public Attribute getIdalphaStyle() {
            return this.idalphaStyle;
        }

        @Override
        public List<SubsetItemValue> getValueList() {
            return this.list;
        }
    }
}

