/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.externalsource;

import fr.exemole.bdfserver.api.externalsource.ExternalSourceType;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mapeadores.util.localisation.Litteral;

public class ExternalSourceTypeBuilder {
    private final String name;
    private final Map<String, ExternalSourceType.Param> paramMap = new LinkedHashMap<String, ExternalSourceType.Param>();
    private Object l10nObject;

    public ExternalSourceTypeBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    public ExternalSourceTypeBuilder setL10nObject(Object l10nObject) {
        this.l10nObject = l10nObject;
        return this;
    }

    public ExternalSourceTypeBuilder addParam(String name, Object paramL10nObject) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (paramL10nObject == null) {
            throw new IllegalArgumentException("paramL10nObject is null");
        }
        this.paramMap.put(name, ExternalSourceUtils.toParam(name, paramL10nObject));
        return this;
    }

    public ExternalSourceType toExternalSourceType() {
        Object finalL10nObject = this.l10nObject;
        if (finalL10nObject == null) {
            finalL10nObject = new Litteral(this.name);
        }
        ExternalSourceType.Param[] array = this.paramMap.values().toArray(new ExternalSourceType.Param[this.paramMap.size()]);
        List<ExternalSourceType.Param> paramList = ExternalSourceUtils.wrap(array);
        return new InternalExternalSourceType(this.name, finalL10nObject, paramList);
    }

    public static ExternalSourceTypeBuilder init(String name) {
        return new ExternalSourceTypeBuilder(name);
    }

    private static class InternalExternalSourceType
    implements ExternalSourceType {
        private final String name;
        private final Object l10nObject;
        private final List<ExternalSourceType.Param> paramList;

        private InternalExternalSourceType(String name, Object l10nObject, List<ExternalSourceType.Param> paramList) {
            this.name = name;
            this.l10nObject = l10nObject;
            this.paramList = paramList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getL10nObject() {
            return this.l10nObject;
        }

        @Override
        public List<ExternalSourceType.Param> getParamList() {
            return this.paramList;
        }
    }
}

