/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.album;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.album.AlbumAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.album.AlbumCreationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.album.AlbumHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.album.AlbumMetadataFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.album.IllustrationAdminFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.album.IllustrationAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.album.IllustrationChangeHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.album.IllustrationUploadConfirmHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.album.IllustrationUploadHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import java.io.File;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public final class AlbumHtmlProducerFactory {
    private static final int ALBUM_ADMIN = 1;
    private static final int ALBUM_READ = 2;
    private static final int ILLUSTRATION = 3;

    private AlbumHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String page = parameters.getOutput();
        RequestMap requestMap = parameters.getRequestMap();
        PermissionChecker permissionChecker = requestHandler.getPermissionChecker();
        switch (AlbumHtmlProducerFactory.getPageType(page)) {
            case 1: {
                Album album = requestHandler.getAlbum();
                permissionChecker.checkSubsetAdmin(album);
                switch (page) {
                    case "album-advancedcommands": {
                        return new AlbumAdvancedCommandsHtmlProducer(parameters, album);
                    }
                    case "album-metadataform": {
                        return new AlbumMetadataFormHtmlProducer(parameters, album);
                    }
                }
                return null;
            }
            case 2: {
                Album album = requestHandler.getAlbum();
                switch (page) {
                    case "album": {
                        return new AlbumHtmlProducer(parameters, album);
                    }
                    case "illustration-upload-new": {
                        String callKey = requestHandler.getCallKey();
                        return IllustrationUploadHtmlProducer.newNewUpload(parameters, album, callKey);
                    }
                    case "illustration-upload-replace": {
                        String callKey = requestHandler.getCallKey();
                        return IllustrationUploadHtmlProducer.newReplaceUpload(parameters, album, callKey);
                    }
                    case "illustration-change": {
                        String callKey = requestHandler.getCallKey();
                        File tmpFile = (File)parameters.getResultObject("obj.tmpfile");
                        if (tmpFile != null) {
                            return IllustrationChangeHtmlProducer.newTmpFileCreate(parameters, album, callKey, tmpFile.getName());
                        }
                        String changeType = requestHandler.getMandatoryParameter("changetype");
                        if (changeType.equals("tmpfile")) {
                            String tmpFileName = requestHandler.getMandatoryParameter("tmpfile");
                            return IllustrationChangeHtmlProducer.newTmpFileChange(parameters, album, callKey, tmpFileName);
                        }
                        if (changeType.equals("illustration")) {
                            Illustration illustration = (Illustration)requestHandler.getMandatorySubsetItem(album);
                            String tmpFileName = requestMap.getParameter("tmpfile");
                            return IllustrationChangeHtmlProducer.newIllustrationChange(parameters, album, callKey, illustration, tmpFileName);
                        }
                        throw BdfErrors.unknownParameterValue("changetype", changeType);
                    }
                }
                return null;
            }
            case 3: {
                Illustration illustration = requestHandler.getIllustration();
                switch (page) {
                    case "illustration-adminform": {
                        permissionChecker.checkWrite(illustration);
                        return new IllustrationAdminFormHtmlProducer(parameters, illustration);
                    }
                    case "illustration-advancedcommands": {
                        permissionChecker.checkSubsetAdmin(illustration.getAlbum());
                        return new IllustrationAdvancedCommandsHtmlProducer(parameters, illustration);
                    }
                }
                return null;
            }
        }
        switch (page) {
            case "album-creationform": {
                permissionChecker.checkFichothequeAdmin();
                return new AlbumCreationFormHtmlProducer(parameters);
            }
            case "illustration-upload-confirm": {
                String callKey = requestHandler.getCallKey();
                File tmpFile = (File)parameters.getResultObject("obj.tmpfile");
                if (tmpFile != null) {
                    return new IllustrationUploadConfirmHtmlProducer(parameters, callKey, tmpFile.getName());
                }
                return null;
            }
        }
        return null;
    }

    private static int getPageType(String page) {
        switch (page) {
            case "album-advancedcommands": 
            case "album-metadataform": {
                return 1;
            }
            case "album": 
            case "illustration-upload-new": 
            case "illustration-upload-replace": 
            case "illustration-change": {
                return 2;
            }
            case "illustration-adminform": 
            case "illustration-advancedcommands": {
                return 3;
            }
        }
        return 0;
    }
}

