/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class UserStoreCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UserStore";
    public static final String NAME_PARAMNAME = "name";
    public static final String KEY_PARAMNAME = "key";
    public static final String VALUE_PARAMNAME = "value";
    private String name;
    private String key;
    private String value;

    public UserStoreCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommand() throws ErrorMessageException {
        Redacteur redacteur = this.bdfUser.getRedacteur();
        synchronized (redacteur) {
            this.bdfServer.store(this.bdfUser, this.name, this.key, this.value);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.name = this.getMandatory(NAME_PARAMNAME);
        if (!BdfUserUtils.isValidStoreName(this.name)) {
            throw BdfErrors.wrongParameterValue(NAME_PARAMNAME, this.name);
        }
        this.key = this.getMandatory(KEY_PARAMNAME);
        if (!BdfUserUtils.isValidStoreKey(this.key)) {
            throw BdfErrors.wrongParameterValue(KEY_PARAMNAME, this.key);
        }
        this.value = this.requestHandler.getTrimedParameter(VALUE_PARAMNAME);
        if (this.value.isEmpty()) {
            this.value = null;
        }
    }
}

