/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class LoginChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "LoginChange";
    public static final String COMMANDKEY = "_ SPH-10";
    public static String NEWLOGIN_PARAMNAME = "newlogin";
    private String newLogin;
    private Redacteur redacteur;

    public LoginChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Sphere sphere = this.redacteur.getSphere();
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            SphereEditor sphereEditor = session.getFichothequeEditor().getSphereEditor(sphere.getSubsetKey());
            try {
                sphereEditor.setLogin(this.redacteur, this.newLogin);
            }
            catch (ExistingIdException iee) {
                throw new ShouldNotOccurException("test before ExistingIdException");
            }
            catch (ParseException pe) {
                throw new ShouldNotOccurException("test before ParseException");
            }
        }
        this.putResultObject("obj.sphere", sphere);
        this.putResultObject("obj.redacteur", this.redacteur);
        this.setDone("_ done.sphere.loginchange", this.newLogin);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.redacteur = this.requestHandler.getMandatoryRedacteur();
        this.getPermissionChecker().checkSphereSupervisor(this.redacteur.getSubsetName()).checkSubsetAdmin(this.redacteur.getSphere());
        String param_new = this.getMandatory(NEWLOGIN_PARAMNAME);
        param_new = param_new.trim();
        if (param_new.length() == 0) {
            throw BdfErrors.error("_ error.empty.login", param_new);
        }
        if (!SphereUtils.testLogin(param_new)) {
            throw BdfErrors.error("_ error.wrong.login", param_new);
        }
        if (this.redacteur.getSphere().getRedacteurByLogin(param_new) != null) {
            throw BdfErrors.error("_ error.existing.login", param_new);
        }
        this.newLogin = param_new;
    }
}

