/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.mapeadores.util.text.StringChecker;

public final class StringCheckerUtils {
    public static final StringChecker URL = new UrlChecker();

    private StringCheckerUtils() {
    }

    public static StringChecker newLengthChecker(int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max < min) {
            max = min;
        }
        return new LengthChecker(min, max);
    }

    private static class LengthChecker
    implements StringChecker {
        private final int min;
        private final int max;

        private LengthChecker(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public String check(String value) {
            if (value == null) {
                return null;
            }
            int length = value.length();
            if (length <= this.max) {
                return value;
            }
            boolean done = false;
            int endIndex = 0;
            for (int i = this.max; i > this.min; --i) {
                char carac = value.charAt(i);
                switch (carac) {
                    case '!': 
                    case '.': 
                    case '?': 
                    case '\u2026': {
                        endIndex = i;
                        done = true;
                    }
                }
                if (done) break;
            }
            if (done) {
                endIndex = this.testNearEndIndex(endIndex, value);
                return value.substring(0, endIndex + 1);
            }
            int stop = this.checkStop(value);
            return value.substring(0, stop) + '\u2026';
        }

        private int checkStop(String value) {
            for (int i = this.max; i > this.min; --i) {
                if (value.charAt(i) != ' ') continue;
                return i;
            }
            return this.min;
        }

        private int testNearEndIndex(int endIndex, String value) {
            int length = value.length();
            int added = 0;
            block4: for (int i = endIndex + 1; i < length; ++i) {
                char carac = value.charAt(i);
                switch (carac) {
                    case '.': {
                        if (++added <= 2) continue block4;
                        return endIndex + added;
                    }
                    case ')': 
                    case ']': {
                        return endIndex + ++added;
                    }
                    default: {
                        return endIndex + added;
                    }
                }
            }
            return endIndex + added;
        }
    }

    private static class UrlChecker
    implements StringChecker {
        private UrlChecker() {
        }

        @Override
        public String check(String href) {
            if (href == null) {
                return null;
            }
            if ((href = href.trim()).length() == 0) {
                return null;
            }
            if (href.startsWith("www.")) {
                href = "http://" + href;
            }
            href = href.replace(" ", "%20");
            try {
                URI uri = new URI(href);
                if (uri.isAbsolute()) {
                    new URL(uri.toString());
                    return uri.toASCIIString();
                }
                new URL("http://" + uri.toString());
                return "http://" + uri.toASCIIString();
            }
            catch (MalformedURLException | URISyntaxException e) {
                return null;
            }
        }
    }
}

