/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import java.util.AbstractList;
import java.util.RandomAccess;
import net.mapeadores.util.primitives.Range;

public class Ranges
extends AbstractList<Range>
implements RandomAccess {
    private int size = 0;
    private Range[] rangeArray = new Range[2];
    private int globalMin = Integer.MAX_VALUE;
    private int globalMax = -1;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Range get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.rangeArray[index];
    }

    public int getGlobalMin() {
        return this.globalMin;
    }

    public int getGlobalMax() {
        return this.globalMax;
    }

    public boolean contains(int value) {
        if (value < this.globalMin || value > this.globalMax) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.rangeArray[i].contains(value)) continue;
            return true;
        }
        return false;
    }

    public void addRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null");
        }
        if (this.size == 0) {
            this.rangeArray[0] = range;
            this.globalMin = range.min();
            this.globalMax = range.max();
            this.size = 1;
            return;
        }
        if (range.min() == this.globalMax + 1) {
            this.rangeArray[this.size - 1] = this.rangeArray[this.size - 1].union(range);
            this.globalMax = range.max();
        } else if (range.min() > this.globalMax) {
            this.checkLength();
            this.rangeArray[this.size] = range;
            ++this.size;
            this.globalMax = range.max();
        } else if (range.max() == this.globalMin - 1) {
            this.rangeArray[0] = this.rangeArray[0].union(range);
            if (this.size > 1) {
                this.mergeFollowing(0);
            }
            this.globalMin = range.min();
        } else if (range.max() < this.globalMin) {
            this.checkLength();
            System.arraycopy(this.rangeArray, 0, this.rangeArray, 1, this.size);
            this.rangeArray[0] = range;
            this.globalMin = range.min();
            ++this.size;
        } else {
            this.globalMin = Math.min(this.globalMin, range.min());
            this.globalMax = Math.max(this.globalMax, range.max());
            this.mergeRanges(range);
        }
    }

    private void mergeRanges(Range range) {
        int nearestIndex = -1;
        for (int i = 0; i < this.size; ++i) {
            Range current = this.rangeArray[i];
            if (current.intersects(range) || current.isNeighbour(range)) {
                Range union = current.union(range);
                if (union.equals(current)) {
                    return;
                }
                this.rangeArray[i] = union;
                if (i < this.size - 1) {
                    this.mergeFollowing(i);
                }
                return;
            }
            if (current.max() >= range.min()) continue;
            nearestIndex = i;
        }
        int nvlength = this.size == this.rangeArray.length ? this.size * 2 : this.rangeArray.length;
        Range[] temp = new Range[nvlength];
        System.arraycopy(this.rangeArray, 0, temp, 0, ++nearestIndex);
        temp[nearestIndex] = range;
        System.arraycopy(this.rangeArray, nearestIndex, temp, nearestIndex + 1, this.size - nearestIndex);
        this.rangeArray = temp;
        ++this.size;
    }

    private void mergeFollowing(int index) {
        Range current;
        int i;
        int length = 0;
        Range start = this.rangeArray[index];
        for (i = index + 1; i < this.size && ((current = this.rangeArray[i]).intersects(start) || current.isNeighbour(start)); ++i) {
            ++length;
            start = start.union(current);
        }
        if (length > 0) {
            this.rangeArray[index] = start;
            for (i = index + length + 1; i < this.size; ++i) {
                this.rangeArray[i - length] = this.rangeArray[i];
            }
            for (i = this.size - length; i < this.size; ++i) {
                this.rangeArray[i] = null;
            }
            this.size -= length;
        }
    }

    private void checkLength() {
        if (this.size == this.rangeArray.length) {
            Range[] nv = new Range[this.size * 2];
            System.arraycopy(this.rangeArray, 0, nv, 0, this.size);
            this.rangeArray = nv;
        }
    }
}

