/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.MotcleFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.filterunit.CorpusExtractFilterUnit;
import net.fichotheque.extraction.filterunit.FicheParentageFilterUnit;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.extraction.run.CorpusExtractor;
import net.fichotheque.extraction.run.FicheExtractInfo;
import net.fichotheque.extraction.run.MotcleExtractInfo;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.Junctions;
import net.fichotheque.namespaces.BdfSpace;
import net.fichotheque.namespaces.ExtractionSpace;
import net.fichotheque.pointeurs.MotclePointeur;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.MotcleIcon;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.SelectionContextBuilder;
import net.fichotheque.xml.extraction.CorpusExtractXMLPart;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.fichotheque.xml.extraction.FicheXMLPart;
import net.fichotheque.xml.extraction.TagNames;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class MotcleXMLPart
extends XMLPart {
    private static final List<SatelliteInfo> EMPTY_SATELLITELIST = Collections.emptyList();
    private final FilterUnitXMLPart filterUnitPart;
    private final ExtractionContext extractionContext;
    private final int extractVersion;
    private final Predicate<FicheMeta> globalFichePredicate;
    private final TagNames tagNames;

    public MotcleXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractionContext = extractParameters.getExtractionContext();
        this.extractVersion = extractParameters.getExtractVersion();
        Predicate<FicheMeta> fichePredicate = extractParameters.getFichePredicate();
        if (fichePredicate == null) {
            fichePredicate = EligibilityUtils.ALL_FICHE_PREDICATE;
        }
        this.globalFichePredicate = fichePredicate;
        this.filterUnitPart = new FilterUnitXMLPart(xmlWriter, extractParameters, this.globalFichePredicate);
        this.tagNames = new TagNames(this.extractVersion);
    }

    public void addMotcle(MotcleExtractInfo motcleExtractInfo) throws IOException {
        List<FilterUnit> filterUnitList;
        MotcleFilter nextFilter;
        MotcleFilter previousFilter;
        MotcleFilter parentFilter;
        MotcleFilter childrenFilter;
        MotcleIcon motcleIcon;
        Motcle motcle = motcleExtractInfo.getMotcle();
        MotcleFilter motcleFilter = motcleExtractInfo.getMotcleFilter();
        String tagName = this.getTagName(motcleFilter);
        Junction junction = motcleExtractInfo.getJunction();
        if (tagName != null) {
            Attribute urlAttribute;
            boolean externalTest;
            int weight;
            this.startOpenTag(tagName);
            this.addAttribute("thesaurus", motcle.getSubsetName());
            this.addAttribute("id", String.valueOf(motcle.getId()));
            String idalpha = motcle.getIdalpha();
            if (idalpha != null) {
                this.addAttribute("idalpha", idalpha);
                if (motcle.getThesaurus().getThesaurusMetadata().isBracketsIdalphaStyle()) {
                    this.addAttribute("style", "brackets");
                }
            }
            if ((weight = ExtractionXMLUtils.getMainWeight(junction)) > 0) {
                this.addAttribute(this.tagNames.getWeightAttributeName(), String.valueOf(weight));
            }
            if (!(externalTest = this.addExternalSourceAttributes(motcle)) && (urlAttribute = motcle.getAttributes().getAttribute(BdfSpace.URL_KEY)) != null) {
                this.addAttribute("url", urlAttribute.getFirstValue());
            }
            List<SatelliteInfo> satelliteList = this.getSatelliteList(motcle);
            if (motcleFilter.isNoneFiltering() && satelliteList.isEmpty()) {
                this.closeEmptyTag();
                return;
            }
            this.endOpenTag();
            this.addSatelliteList(satelliteList);
            ExtractionXMLUtils.writeJunction(this, junction, this.tagNames);
        } else if (motcleFilter.isNoneFiltering()) {
            return;
        }
        if (motcleFilter.withIcon() && (motcleIcon = motcle.getMotcleIcon()) != null) {
            this.addMotcleIcon(motcleIcon);
        }
        if (motcleFilter.withLevel()) {
            this.addSimpleElement("level", String.valueOf(motcle.getLevel()));
        }
        if (motcleFilter.withLabels()) {
            LabelUtils.addLabels(this, motcle.getLabels());
        }
        if (motcleFilter.withFicheStylePhrase()) {
            ExtractionXMLUtils.writePhrase(this, motcle, "fichestyle", this.extractionContext.getLangContext(), this.extractVersion);
        }
        if ((childrenFilter = motcleFilter.getChildrenFilter()) != null) {
            for (Motcle child : motcle.getChildList()) {
                MotcleExtractInfo childExtractInfo = ExtractionXMLUtils.toMotcleExtractInfo(child, childrenFilter);
                this.addMotcle(childExtractInfo);
            }
        }
        if ((parentFilter = motcleFilter.getParentFilter()) != null) {
            Motcle parentMotcle = motcle.getParent();
            this.addLinkedMotcle(parentMotcle, motcleFilter.getParentFilter());
        }
        if ((previousFilter = motcleFilter.getPreviousFilter()) != null) {
            Motcle previousMotcle = motcle.getPrevious();
            this.addLinkedMotcle(previousMotcle, previousFilter);
        }
        if ((nextFilter = motcleFilter.getNextFilter()) != null) {
            Motcle nextMotcle = motcle.getNext();
            this.addLinkedMotcle(nextMotcle, nextFilter);
        }
        if (!(filterUnitList = motcleFilter.getFilterUnitList()).isEmpty()) {
            this.filterUnitPart.updatePointeur(motcle);
            this.filterUnitPart.addFilterUnitList(filterUnitList);
        }
        if (tagName != null) {
            this.closeTag(tagName);
        }
    }

    private void addMotcleIcon(MotcleIcon motcleIcon) throws IOException {
        this.startOpenTag("icon");
        this.addAttribute("char", motcleIcon.getCharIcon());
        this.closeEmptyTag();
    }

    private void addLinkedMotcle(Motcle linkedMotcle, MotcleFilter linkedMotcleFilter) throws IOException {
        if (linkedMotcle == null) {
            return;
        }
        this.addMotcle(ExtractionXMLUtils.toMotcleExtractInfo(linkedMotcle, linkedMotcleFilter));
    }

    private void addSatelliteList(List<SatelliteInfo> satelliteList) throws IOException {
        for (SatelliteInfo satelliteInfo : satelliteList) {
            String lang = satelliteInfo.lang;
            this.startOpenTag("satellite");
            this.addAttribute("corpus", satelliteInfo.corpusName);
            if (lang != null) {
                this.addAttribute("lang", lang);
            }
            this.closeEmptyTag();
        }
    }

    private List<SatelliteInfo> getSatelliteList(Motcle motcle) {
        Thesaurus thesaurus = motcle.getThesaurus();
        List<Corpus> satelliteCorpusList = thesaurus.getSatelliteCorpusList();
        if (satelliteCorpusList.isEmpty()) {
            return EMPTY_SATELLITELIST;
        }
        HashSet<String> existingString = new HashSet<String>();
        for (Corpus corpus : satelliteCorpusList) {
            FicheMeta ficheMeta = corpus.getFicheMetaById(motcle.getId());
            if (ficheMeta == null || !this.globalFichePredicate.test(ficheMeta)) continue;
            existingString.add(corpus.getSubsetName());
        }
        if (existingString.isEmpty()) {
            return EMPTY_SATELLITELIST;
        }
        Attribute satelliteAttribute = motcle.getAttributes().getAttribute(ExtractionSpace.SATELLITE_ATTRIBUTEKEY);
        if (satelliteAttribute != null) {
            if (satelliteAttribute.getFirstValue().startsWith("_")) {
                return EMPTY_SATELLITELIST;
            }
            for (String value : satelliteAttribute) {
                if (!existingString.contains(value)) continue;
                return Collections.singletonList(new SatelliteInfo(value, null));
            }
            return EMPTY_SATELLITELIST;
        }
        ArrayList<SatelliteInfo> arrayList = new ArrayList<SatelliteInfo>();
        satelliteAttribute = thesaurus.getThesaurusMetadata().getAttributes().getAttribute(ExtractionSpace.SATELLITE_ATTRIBUTEKEY);
        if (satelliteAttribute != null) {
            for (String value : satelliteAttribute) {
                if (!existingString.contains(value)) continue;
                arrayList.add(new SatelliteInfo(value, null));
            }
        }
        for (Attribute attribute : thesaurus.getThesaurusMetadata().getAttributes()) {
            String lang;
            String attributeKey = attribute.getAttributeKey().toString();
            if (!attributeKey.startsWith("extraction:satellite:") || (lang = attributeKey.substring("extraction:satellite:".length())).isEmpty()) continue;
            for (String value : attribute) {
                if (!existingString.contains(value)) continue;
                arrayList.add(new SatelliteInfo(value, lang));
            }
        }
        return arrayList;
    }

    private String getTagName(MotcleFilter motcleFilter) {
        TagNameInfo tagNameInfo = motcleFilter.getTagNameInfo();
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        switch (motcleFilter.getType()) {
            case 2: {
                return "parent";
            }
            case 4: {
                return "next";
            }
            case 3: {
                return "previous";
            }
        }
        return "motcle";
    }

    private boolean addExternalSourceAttributes(Motcle motcle) throws IOException {
        DynamicEditPolicy dynamicEditPolicy = this.extractionContext.getPolicyProvider().getDynamicEditPolicy(motcle.getThesaurus());
        if (!dynamicEditPolicy.getType().equals("external")) {
            return false;
        }
        ExternalSourceDef externalSourceDef = ((DynamicEditPolicy.External)dynamicEditPolicy).getExternalSourceDef();
        String fichothequeName = externalSourceDef.getParam("fichotheque");
        if (fichothequeName == null) {
            return false;
        }
        String externalCorpusName = externalSourceDef.getParam("corpus");
        if (externalCorpusName == null) {
            return false;
        }
        this.addAttribute("external-fichotheque", fichothequeName);
        this.addAttribute("external-corpus", externalCorpusName);
        return true;
    }

    private static class FilterUnitXMLPart
    extends XMLPart {
        private final ExtractParameters extractParameters;
        private final ExtractionContext extractionContext;
        private final SelectionContext selectionContext;
        private final Predicate<FicheMeta> globalFichePredicate;
        private CorpusExtractXMLPart corpusExtractXMLPart = null;
        private FicheXMLPart satelliteFicheXMLPart = null;
        private MotclePointeur motclePointeur;

        private FilterUnitXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters, Predicate<FicheMeta> globalFichePredicate) {
            super(xmlWriter);
            this.extractParameters = extractParameters;
            this.extractionContext = extractParameters.getExtractionContext();
            this.globalFichePredicate = globalFichePredicate;
            this.selectionContext = SelectionContextBuilder.build(this.extractionContext).setSubsetAccessPredicate(this.extractionContext.getSubsetAccessPredicate()).setFichePredicate(extractParameters.getFichePredicate()).toSelectionContext();
        }

        private void updatePointeur(Motcle motcle) {
            Thesaurus thesaurus = motcle.getThesaurus();
            if (this.motclePointeur != null && !this.motclePointeur.getSubset().equals(thesaurus)) {
                this.motclePointeur = null;
            }
            if (this.motclePointeur == null) {
                this.motclePointeur = PointeurFactory.newMotclePointeur(motcle.getThesaurus());
            }
            this.motclePointeur.setCurrentSubsetItem(motcle);
        }

        private void addFilterUnitList(List<FilterUnit> filterUnitList) throws IOException {
            for (FilterUnit filterUnit : filterUnitList) {
                if (filterUnit instanceof CorpusExtractFilterUnit) {
                    this.addCorpusExtract((CorpusExtractFilterUnit)filterUnit);
                    continue;
                }
                if (!(filterUnit instanceof FicheParentageFilterUnit)) continue;
                this.addSatelliteFiche((FicheParentageFilterUnit)filterUnit);
            }
        }

        private void addSatelliteFiche(FicheParentageFilterUnit filterUnit) throws IOException {
            int motcleid = this.motclePointeur.getCurrentSubsetItem().getId();
            List<Corpus> corpusList = this.toCorpusList(filterUnit);
            for (Corpus corpus : corpusList) {
                FicheMeta ficheMeta = corpus.getFicheMetaById(motcleid);
                if (ficheMeta == null || !this.globalFichePredicate.test(ficheMeta)) continue;
                FicheExtractInfo ficheExtractInfo = ExtractionXMLUtils.toFicheExtractInfo(ficheMeta, filterUnit.getFicheFilter());
                if (this.satelliteFicheXMLPart == null) {
                    this.satelliteFicheXMLPart = new FicheXMLPart(this.getXMLWriter(), this.extractParameters);
                }
                this.satelliteFicheXMLPart.addFiche(ficheExtractInfo);
            }
        }

        private void addCorpusExtract(CorpusExtractFilterUnit filterUnit) throws IOException {
            CorpusExtractDef corpusExtractDef = filterUnit.getCorpusExtractDef();
            CorpusExtractor corpusExtractor = this.extractionContext.getExtractorProvider().getCorpusExtractor(corpusExtractDef);
            FicheSelector indexationFicheSelector = FicheSelectorBuilder.init(this.selectionContext).addAll(corpusExtractDef.getConditionEntryList()).toFicheSelector();
            for (Corpus corpus : indexationFicheSelector.getCorpusList()) {
                Junctions junctions = corpusExtractDef.isDescendantAxis() ? this.motclePointeur.getDescendantAxisJunctionList(corpus) : this.motclePointeur.getJunctions(corpus);
                for (Junctions.Entry entry : junctions.getEntryList()) {
                    FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
                    Junction filteredJunction = indexationFicheSelector.isSelected(ficheMeta, entry.getJunction());
                    if (filteredJunction == null) continue;
                    corpusExtractor.add(ficheMeta, filteredJunction);
                }
            }
            if (this.corpusExtractXMLPart == null) {
                this.corpusExtractXMLPart = new CorpusExtractXMLPart(this.getXMLWriter(), this.extractParameters);
            }
            this.corpusExtractXMLPart.addCorpusExtract(corpusExtractor.getCorpusExtractResult());
        }

        private List<Corpus> toCorpusList(FicheParentageFilterUnit filterUnit) {
            Thesaurus thesaurus = (Thesaurus)this.motclePointeur.getSubset();
            List<SubsetKey> subsetKeyList = filterUnit.getSubsetKeyList();
            if (subsetKeyList.isEmpty()) {
                return thesaurus.getSatelliteCorpusList();
            }
            Fichotheque fichotheque = thesaurus.getFichotheque();
            ArrayList<Corpus> list = new ArrayList<Corpus>();
            for (SubsetKey subsetKey : subsetKeyList) {
                Subset masterSubset;
                Corpus corpus = (Corpus)fichotheque.getSubset(subsetKey);
                if (corpus == null || (masterSubset = corpus.getMasterSubset()) == null || !masterSubset.equals(thesaurus)) continue;
                list.add(corpus);
            }
            return list;
        }
    }

    private static class SatelliteInfo {
        private final String corpusName;
        private final String lang;

        private SatelliteInfo(String corpusName, String lang) {
            this.corpusName = corpusName;
            this.lang = lang;
        }
    }
}

