/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.selection.DocumentCondition;

public class DocumentConditionBuilder {
    private final List<DocumentCondition.Entry> entryList = new ArrayList<DocumentCondition.Entry>();
    private String logicalOperator = "and";

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public DocumentConditionBuilder setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
        return this;
    }

    public DocumentConditionBuilder addEntry(DocumentCondition.Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry is null");
        }
        this.entryList.add(entry);
        return this;
    }

    public DocumentCondition toDocumentCondition() {
        EntryList finalEntryList = new EntryList(this.entryList.toArray(new DocumentCondition.Entry[this.entryList.size()]));
        return new InternalDocumentCondition(this.logicalOperator, finalEntryList);
    }

    public static DocumentConditionBuilder init() {
        return new DocumentConditionBuilder();
    }

    private static class EntryList
    extends AbstractList<DocumentCondition.Entry>
    implements RandomAccess {
        private final DocumentCondition.Entry[] array;

        private EntryList(DocumentCondition.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public DocumentCondition.Entry get(int index) {
            return this.array[index];
        }
    }

    private static class InternalDocumentCondition
    implements DocumentCondition {
        private final String logicalOperator;
        private final List<DocumentCondition.Entry> entryList;

        private InternalDocumentCondition(String logicalOperator, List<DocumentCondition.Entry> entryList) {
            this.logicalOperator = logicalOperator;
            this.entryList = entryList;
        }

        @Override
        public String getLogicalOperator() {
            return this.logicalOperator;
        }

        @Override
        public List<DocumentCondition.Entry> getEntryList() {
            return this.entryList;
        }
    }
}

