/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.junction.Junctions;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.utils.JunctionUtils;

public final class PointeurUtils {
    private PointeurUtils() {
    }

    public static SubsetItemPointeur checkMasterPointeur(FichePointeur fichePointeur, boolean master) {
        if (master) {
            Subset masterSubset = fichePointeur.getCorpus().getMasterSubset();
            if (masterSubset != null) {
                return fichePointeur.getParentagePointeur(masterSubset.getSubsetKey());
            }
            return fichePointeur;
        }
        return fichePointeur;
    }

    public static DateItem getDate(FichePointeur fichePointeur, CorpusField corpusField) {
        return PointeurUtils.getDate(fichePointeur, corpusField.getFieldKey());
    }

    public static DateItem getDate(FichePointeur fichePointeur, FieldKey fieldKey) {
        Object obj = fichePointeur.getValue(fieldKey);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof DateItem)) {
            return null;
        }
        return (DateItem)obj;
    }

    public static AmountItem getAmount(FichePointeur fichePointeur, CorpusField corpusField) {
        return PointeurUtils.getAmount(fichePointeur, corpusField.getFieldKey());
    }

    public static AmountItem getAmount(FichePointeur fichePointeur, FieldKey fieldKey) {
        Object obj = fichePointeur.getValue(fieldKey);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof AmountItem)) {
            return null;
        }
        return (AmountItem)obj;
    }

    public static NumberItem getNumber(FichePointeur fichePointeur, CorpusField corpusField) {
        return PointeurUtils.getNumber(fichePointeur, corpusField.getFieldKey());
    }

    public static NumberItem getNumber(FichePointeur fichePointeur, FieldKey fieldKey) {
        Object obj = fichePointeur.getValue(fieldKey);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof NumberItem)) {
            return null;
        }
        return (NumberItem)obj;
    }

    public static FichePointeur filter(FichePointeur fichePointeur, SubsetEligibility subsetEligibility, Predicate<FieldKey> fieldPredicate) {
        return new FilteredFichePointeur(fichePointeur, subsetEligibility, fieldPredicate);
    }

    private static class FilteredFichePointeur
    implements FichePointeur {
        private final FichePointeur originalFichePointeur;
        private final SubsetEligibility subsetEligibility;
        private final Predicate<FieldKey> fieldPredicate;

        private FilteredFichePointeur(FichePointeur originalFichePointeur, SubsetEligibility subsetEligibility, Predicate<FieldKey> fieldPredicate) {
            this.originalFichePointeur = originalFichePointeur;
            this.subsetEligibility = subsetEligibility;
            this.fieldPredicate = fieldPredicate;
        }

        @Override
        public boolean isWithSection() {
            return this.originalFichePointeur.isWithSection();
        }

        @Override
        public void enableCache(boolean enable) {
            this.originalFichePointeur.enableCache(enable);
        }

        @Override
        public Object getValue(FieldKey fieldKey) {
            if (this.fieldPredicate.test(fieldKey)) {
                return this.originalFichePointeur.getValue(fieldKey);
            }
            return null;
        }

        @Override
        public SubsetItemPointeur getParentagePointeur(SubsetKey parentageSubsetKey) {
            return this.originalFichePointeur.getParentagePointeur(parentageSubsetKey);
        }

        @Override
        public SubsetItemPointeur getAssociatedPointeur(Subset subset) {
            return this.originalFichePointeur.getAssociatedPointeur(subset);
        }

        @Override
        public void setCurrentSubsetItem(int id) {
            this.originalFichePointeur.setCurrentSubsetItem(id);
        }

        @Override
        public void setCurrentSubsetItem(SubsetItem subsetItem) {
            this.originalFichePointeur.setCurrentSubsetItem(subsetItem);
        }

        @Override
        public SubsetItem getCurrentSubsetItem() {
            return this.originalFichePointeur.getCurrentSubsetItem();
        }

        @Override
        public Subset getSubset() {
            return this.originalFichePointeur.getSubset();
        }

        @Override
        public Junctions getJunctions(Subset subset) {
            if (this.subsetEligibility.accept(subset)) {
                return this.originalFichePointeur.getJunctions(subset);
            }
            return JunctionUtils.EMPTY_JUNCTIONS;
        }

        @Override
        public Object getCurrentObject(String objectName) {
            return this.originalFichePointeur.getCurrentObject(objectName);
        }

        @Override
        public void putCurrentObject(String objectName, Object object) {
            this.originalFichePointeur.putCurrentObject(objectName, object);
        }

        @Override
        public Object getPointeurObject(String objectName) {
            return this.originalFichePointeur.getPointeurObject(objectName);
        }

        @Override
        public void putPointeurObject(String objectName, Object object) {
            this.originalFichePointeur.putPointeurObject(objectName, object);
        }
    }
}

