/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.handlers;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.parsers.FicheParser;

public abstract class FicheHandler {
    final CorpusField corpusField;
    int uniqueIndex = -1;
    List<Integer> indexList;

    private FicheHandler(CorpusField corpusField) {
        this.corpusField = corpusField;
    }

    public CorpusField getCorpusField() {
        return this.corpusField;
    }

    public boolean addIndex(int index) {
        if (index == -1) {
            this.uniqueIndex = index;
        } else {
            this.uniqueIndex = -2;
            if (this.indexList == null) {
                this.indexList = new ArrayList<Integer>();
            }
            this.indexList.add(index);
        }
        return true;
    }

    public abstract void handle(Row var1, FicheParser.Buffer var2);

    public static FicheHandler fromCorpusField(CorpusField corpusField) {
        switch (FicheHandler.getHandlerType(corpusField)) {
            case 1: {
                return new UniqueCorpusField(corpusField);
            }
            case 2: {
                return new MultiCorpusField(corpusField);
            }
        }
        return new NoDoublonCorpusField(corpusField);
    }

    public static FicheHandler fromSubfield(CorpusField corpusField, SubfieldKey subfieldKey) {
        return new Subfield(corpusField, subfieldKey);
    }

    private static int getHandlerType(CorpusField corpusField) {
        switch (corpusField.getCategory()) {
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                switch (corpusField.getFieldString()) {
                    case "title": 
                    case "subtitle": {
                        return 1;
                    }
                    case "owners": {
                        return 2;
                    }
                }
            }
        }
        return 0;
    }

    private static class UniqueCorpusField
    extends FicheHandler {
        private UniqueCorpusField(CorpusField corpusField) {
            super(corpusField);
        }

        @Override
        public void handle(Row row, FicheParser.Buffer ficheParserBuffer) {
            int columnCount = row.getColumnCount();
            if (this.uniqueIndex > -1) {
                if (this.uniqueIndex < columnCount) {
                    ficheParserBuffer.parseCorpusField(this.corpusField, row.getColumnValue(this.uniqueIndex));
                }
            } else {
                StringBuilder buf = new StringBuilder();
                int indexCount = this.indexList.size();
                for (int i = 0; i < indexCount; ++i) {
                    String value;
                    int index = (Integer)this.indexList.get(i);
                    if (index >= columnCount || (value = row.getColumnValue(index)) == null) continue;
                    buf.append(value);
                }
                ficheParserBuffer.parseCorpusField(this.corpusField, buf.toString());
            }
        }
    }

    private static class MultiCorpusField
    extends FicheHandler {
        private MultiCorpusField(CorpusField corpusField) {
            super(corpusField);
        }

        @Override
        public void handle(Row row, FicheParser.Buffer ficheParser) {
            int columnCount = row.getColumnCount();
            if (this.uniqueIndex > -1) {
                if (this.uniqueIndex < columnCount) {
                    ficheParser.parseCorpusField(this.corpusField, row.getColumnValue(this.uniqueIndex));
                }
            } else {
                int indexCount = this.indexList.size();
                for (int i = 0; i < indexCount; ++i) {
                    int index = (Integer)this.indexList.get(i);
                    if (index >= columnCount) continue;
                    ficheParser.parseCorpusField(this.corpusField, row.getColumnValue(index));
                }
            }
        }
    }

    private static class NoDoublonCorpusField
    extends FicheHandler {
        private NoDoublonCorpusField(CorpusField corpusField) {
            super(corpusField);
        }

        @Override
        public boolean addIndex(int index) {
            if (this.uniqueIndex > -1) {
                return false;
            }
            this.uniqueIndex = index;
            return true;
        }

        @Override
        public void handle(Row row, FicheParser.Buffer ficheParserBuffer) {
            int columnCount = row.getColumnCount();
            if (this.uniqueIndex > -1 && this.uniqueIndex < columnCount) {
                ficheParserBuffer.parseCorpusField(this.corpusField, row.getColumnValue(this.uniqueIndex));
            }
        }
    }

    private static class Subfield
    extends FicheHandler {
        private final SubfieldKey subfieldKey;

        private Subfield(CorpusField corpusField, SubfieldKey subfieldKey) {
            super(corpusField);
            this.subfieldKey = subfieldKey;
        }

        @Override
        public boolean addIndex(int index) {
            if (this.uniqueIndex > -1) {
                return false;
            }
            this.uniqueIndex = index;
            return true;
        }

        @Override
        public void handle(Row row, FicheParser.Buffer ficheParserBuffer) {
            int columnCount = row.getColumnCount();
            if (this.uniqueIndex > -1 && this.uniqueIndex < columnCount) {
                ficheParserBuffer.parseSubfield(this.corpusField, this.subfieldKey, row.getColumnValue(this.uniqueIndex));
            }
        }
    }
}

