/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.patterndefs;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.format.PatternDef;
import net.fichotheque.tools.format.patterndefs.PatternDefBuilder;
import net.fichotheque.tools.format.patterndefs.PatternDefUtils;

public class PatternDefCatalog {
    public static final List<PatternDef> ATTRIBUTE = PatternDefCatalog.attribute();
    public static final List<PatternDef> DOCUMENT = PatternDefCatalog.document();
    public static final List<PatternDef> EXTRACTION = PatternDefCatalog.extraction();
    public static final List<PatternDef> FICHEBLOCK = PatternDefCatalog.ficheBlock();
    public static final List<PatternDef> FICHEMETA = PatternDefCatalog.ficheMeta();
    public static final List<PatternDef> ILLUSTRATION = PatternDefCatalog.illustration();
    public static final List<PatternDef> MOTCLE_MULTI = PatternDefCatalog.motcle("multi");
    public static final List<PatternDef> MOTCLE_IDALPHA = PatternDefCatalog.motcle("idalpha");
    public static final List<PatternDef> MOTCLE_BABELIEN = PatternDefCatalog.motcle("babelien");
    public static final List<PatternDef> IDALPHA = PatternDefCatalog.idalpha();
    public static final List<PatternDef> VALUE = PatternDefCatalog.value();

    private PatternDefCatalog() {
    }

    private static List<PatternDef> attribute() {
        return PatternDefCatalog.init().add("value").add("formsyntax").toList();
    }

    private static List<PatternDef> document() {
        return PatternDefCatalog.init().add("basename").add("extensions").add("addenda").add("id").add("weight").add("formsyntax").addJson(new String[]{"-type", "-id", "-basename", "-versions", "addenda", "size"}).toList();
    }

    private static List<PatternDef> extraction() {
        return PatternDefCatalog.init().add("xml").add(PatternDefBuilder.init("transformation").setDirectValueType("transformation_format").addParameter("startlevel", "1\u20266").addParameter("externaltarget", "_blank").addParameter("lang", "_fiche, lang")).add("formsyntax").toList();
    }

    private static List<PatternDef> ficheBlock() {
        return PatternDefCatalog.init().add("text").add("values").add("xml").add(PatternDefBuilder.init("transformation").setDirectValueType("transformation_section").addParameter("startlevel", "1\u20266").addParameter("externaltarget", "_blank").addParameter("lang", "_fiche, lang")).add("formsyntax").toList();
    }

    public static List<PatternDef> ficheItem(String ficheItemType) {
        switch (ficheItemType) {
            case "amount": {
                return PatternDefCatalog.init().add("code").add(PatternDefBuilder.init("label").setDirectValueType("langs").addParameter("subunit", "force").addParameter("sep", "")).add("currency").add("decimal").add("long").add("formsyntax").addJson(new String[]{"-type", "-currency", "-decimal", "-long", "code", "labels", "formsyntax"}).toList();
            }
            case "country": {
                return PatternDefCatalog.init().add("code").add("label", "langs").add("formsyntax").addJson(new String[]{"-type", "-code", "labels", "formsyntax"}).toList();
            }
            case "date": {
                return PatternDefCatalog.init().add("code").add("iso").add("lastday").add("year").add("isomonth").add("lastmonth").add(PatternDefBuilder.init("label").setDirectValueType("langs").addParameter("datesyle", "short", "medium", "long", "full").addParameter("truncate", "month", "quarter", "halfyear", "year").addParameter("sep", "")).add(PatternDefBuilder.init("pattern").setDirectValueType("letters").addParameter("lang", "langs").addParameter("sep", "")).add("formsyntax").add(PatternDefCatalog.initJson("-type", "-extent", "-code", "-iso", "lastday", "year", "isomonth", "lastmonth", "labels", "monthlabels", "formsyntax").addParameter("datastyle", "short", "medium", "long", "full")).toList();
            }
            case "email": {
                return PatternDefCatalog.init().add("complete").add("address").add("name").add("formsyntax").addJson(new String[]{"-type", "-address", "complete", "name", "formsyntax"}).toList();
            }
            case "geopoint": {
                return PatternDefCatalog.init().add("lat").add("latlabel", "langs").add("lon").add("lonlabel", "langs").add("formsyntax").addJson(new String[]{"-type", "-lat", "-lon", "latlabels", "lonlabels", "formsyntax"}).toList();
            }
            case "image": {
                return PatternDefCatalog.init().add(PatternDefBuilder.init("src").addParameter("base", "")).add("alt").add("title").add("formsyntax").addJson(new String[]{"-type", "-src", "title", "alt", "formsyntax"}).toList();
            }
            case "person": {
                return PatternDefCatalog.init().add("code").add("sphere").add("login").add("standard").add("directory").add("updirectory").add("biblio").add("upbiblio").add("surname").add("upsurname").add("forename").add("nonlatin").add("surnamefirst").add("organism").add("formsyntax").addJson(new String[]{"-type", "-standard", "code", "sphere", "login", "directory", "updirectory", "biblio", "upbiblio", "surname", "upsurname", "forename", "nonlatin", "surnamefirst", "organism", "formsyntax"}).toList();
            }
            case "item": {
                return PatternDefCatalog.init().add("value").add("formsyntax").addJson(new String[]{"-type", "-value", "formsyntax"}).toList();
            }
            case "language": {
                return PatternDefCatalog.init().add("code").add("label", "langs").add("formsyntax").addJson(new String[]{"-type", "-code", "labels", "formsyntax"}).toList();
            }
            case "link": {
                return PatternDefCatalog.init().add(PatternDefBuilder.init("href").addParameter("base", "")).add("title").add("comment").add("formsyntax").addJson(new String[]{"-type", "-href", "title", "comment", "formsyntax"}).toList();
            }
            case "number": {
                return PatternDefCatalog.init().add("code").add("label", "langs").add("formsyntax").addJson(new String[]{"-type", "-code", "-value", "labels", "formsyntax"}).toList();
            }
            case "para": {
                return PatternDefCatalog.init().add("raw").add("transformation", "transformation_section").add("formsyntax").addJson(new String[]{"-type", "-raw", "formsyntax"}).toList();
            }
        }
        throw new IllegalArgumentException("Unknown ficheItemType: " + ficheItemType);
    }

    private static List<PatternDef> ficheMeta() {
        return PatternDefCatalog.init().add("id").add("title").add("lang").add("corpus").add("weight").add("formsyntax").addJsonWithProperties(new String[]{"-type", "-id", "corpus", "lang", "title"}).toList();
    }

    private static List<PatternDef> idalpha() {
        return PatternDefCatalog.init().add("value").add("significant").toList();
    }

    private static List<PatternDef> illustration() {
        return PatternDefCatalog.init().add("album").add("id").add("format").add("weight").add("formsyntax").addJson(new String[]{"-type", "-id", "-format", "filename"}).toList();
    }

    private static List<PatternDef> motcle(String thesaurusType) {
        switch (thesaurusType) {
            case "multi": {
                return PatternDefCatalog.init().add("id").add("label", "langs").add("weight").add("thesaurus").add("position", "position").add("parent_id").add("formsyntax").addJsonWithProperties(new String[]{"-type", "-id", "-idalpha", "thesaurus", "idalpha_significant", "idalpha_always", "labels"}).toList();
            }
            case "idalpha": {
                return PatternDefCatalog.init().add("id").add("idalpha", "idalpha").add("label", "langs").add("weight").add("thesaurus").add("position", "position").add("parent_id").add("parent_idalpha", "idalpha").add("formsyntax").addJsonWithProperties(new String[]{"-type", "-id", "-idalpha", "thesaurus", "idalpha(_significant)", "labels"}).toList();
            }
            case "babelien": {
                return PatternDefCatalog.init().add("id").add("label").add("weight").add("thesaurus").add("position", "position").add("parent_id").add("lang").add("formsyntax").addJsonWithProperties(new String[]{"-type", "-id", "thesaurus", "idalpha", "labels"}).toList();
            }
        }
        throw new IllegalArgumentException("Unknown thesaurusType: " + thesaurusType);
    }

    private static List<PatternDef> value() {
        return PatternDefCatalog.init().add("value").add("formsyntax").toList();
    }

    private static PatternDefBuilder initJson(String ... availableInclude) {
        return PatternDefBuilder.init("json").addParameter("include", availableInclude);
    }

    private static ListBuilder init() {
        return new ListBuilder();
    }

    private static class ListBuilder {
        private final List<PatternDef> list = new ArrayList<PatternDef>();

        private ListBuilder() {
        }

        private ListBuilder add(String name) {
            this.list.add(PatternDefBuilder.init(name).toPatternDef());
            return this;
        }

        private ListBuilder add(String name, String parameterFamily) {
            this.list.add(PatternDefBuilder.init(name).setDirectValueType(parameterFamily).toPatternDef());
            return this;
        }

        private ListBuilder addJson(String ... availableInclude) {
            this.list.add(PatternDefBuilder.init("json").addParameter("include", availableInclude).toPatternDef());
            return this;
        }

        private ListBuilder addJsonWithProperties(String ... availableInclude) {
            this.list.add(PatternDefBuilder.init("json").addParameter("include", availableInclude).addParameter("properties", new String[0]).toPatternDef());
            return this;
        }

        private ListBuilder add(PatternDef patternDef) {
            this.list.add(patternDef);
            return this;
        }

        private ListBuilder add(PatternDefBuilder patternDefBuilder) {
            this.list.add(patternDefBuilder.toPatternDef());
            return this;
        }

        private List<PatternDef> toList() {
            return PatternDefUtils.wrap(this.list.toArray(new PatternDef[this.list.size()]));
        }
    }
}

