/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.MotcleFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.def.ThesaurusExtractDef;
import net.fichotheque.extraction.filterunit.CorpusExtractFilterUnit;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.extraction.filterunit.ThesaurusExtractFilterUnit;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.SubsetCondition;
import net.fichotheque.tools.extraction.builders.FicheFilterBuilder;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FilterUnitCatalog;

public final class ExtractionDefFilterEngine {
    private final PermissionSummary permissionSummary;

    private ExtractionDefFilterEngine(PermissionSummary permissionSummary) {
        this.permissionSummary = permissionSummary;
    }

    private CorpusExtractDef filter(CorpusExtractDef corpusExtractDef) {
        FicheFilter filteredFicheFilter;
        List<FicheCondition.Entry> filteredConditionEntryList;
        if (corpusExtractDef == null) {
            return null;
        }
        List<FicheCondition.Entry> originalConditionEntryList = corpusExtractDef.getConditionEntryList();
        if (originalConditionEntryList.isEmpty()) {
            filteredConditionEntryList = originalConditionEntryList;
        } else {
            filteredConditionEntryList = new ArrayList<FicheCondition.Entry>();
            for (FicheCondition.Entry entry : originalConditionEntryList) {
                if (!this.isValid(entry)) continue;
                filteredConditionEntryList.add(entry);
            }
            if (filteredConditionEntryList.isEmpty()) {
                return null;
            }
        }
        FicheFilter originalFicheFilter = corpusExtractDef.getFicheFilter();
        if (originalFicheFilter.getFilterUnitList().isEmpty()) {
            filteredFicheFilter = originalFicheFilter;
        } else {
            FicheFilterBuilder builder = FicheFilterBuilder.init().setTagNameInfo(originalFicheFilter.getTagNameInfo());
            for (FilterUnit originalFilterUnit : originalFicheFilter.getFilterUnitList()) {
                FilterUnit filteredFilterUnit = this.filter(originalFilterUnit);
                if (filteredFilterUnit == null) continue;
                builder.add(filteredFilterUnit);
            }
            filteredFicheFilter = builder.toFicheFilter();
        }
        return new FilteredCorpusExtractDef(corpusExtractDef, filteredFicheFilter, filteredConditionEntryList);
    }

    private ThesaurusExtractDef filter(ThesaurusExtractDef thesaurusExtractDef) {
        MotcleFilter filteredMotcleFilter;
        List<MotcleCondition.Entry> filteredConditionEntryList;
        if (thesaurusExtractDef == null) {
            return null;
        }
        List<MotcleCondition.Entry> originalConditionEntryList = thesaurusExtractDef.getConditionEntryList();
        if (originalConditionEntryList.isEmpty()) {
            filteredConditionEntryList = originalConditionEntryList;
        } else {
            filteredConditionEntryList = new ArrayList<MotcleCondition.Entry>();
            for (MotcleCondition.Entry entry : originalConditionEntryList) {
                if (!this.isValid(entry)) continue;
                filteredConditionEntryList.add(entry);
            }
            if (filteredConditionEntryList.isEmpty()) {
                return null;
            }
        }
        MotcleFilter originalMotcleFilter = thesaurusExtractDef.getMotcleFilter();
        List<FilterUnit> originalFilterUnitList = originalMotcleFilter.getFilterUnitList();
        if (originalFilterUnitList.isEmpty()) {
            filteredMotcleFilter = originalMotcleFilter;
        } else {
            ArrayList<FilterUnit> filteredList = new ArrayList<FilterUnit>();
            for (FilterUnit originalFilterUnit : originalFilterUnitList) {
                FilterUnit filteredFilterUnit = this.filter(originalFilterUnit);
                if (filteredFilterUnit == null) continue;
                filteredList.add(filteredFilterUnit);
            }
            filteredMotcleFilter = new FilteredMotcleFilter(originalMotcleFilter, ExtractionUtils.toImmutableList(filteredList));
        }
        return new FilteredThesaurusExtractDef(thesaurusExtractDef, filteredMotcleFilter, filteredConditionEntryList);
    }

    private boolean isValid(FicheCondition.Entry entry) {
        if (entry.includeSatellites()) {
            return true;
        }
        FicheQuery ficheQuery = entry.getFicheQuery();
        return this.isValid(ficheQuery.getCorpusCondition());
    }

    private boolean isValid(MotcleCondition.Entry entry) {
        if (entry.isWithMaster()) {
            return true;
        }
        MotcleQuery motcleQuery = entry.getMotcleQuery();
        return this.isValid(motcleQuery.getThesaurusCondition());
    }

    private boolean isValid(SubsetCondition subsetCondition) {
        if (subsetCondition.isExclude() || subsetCondition.isAll()) {
            return true;
        }
        for (SubsetKey subsetKey : subsetCondition.getSubsetKeySet()) {
            if (!this.permissionSummary.hasAccess(subsetKey)) continue;
            return true;
        }
        return false;
    }

    private FilterUnit filter(FilterUnit originalFilterUnit) {
        List<String> roles = originalFilterUnit.getParameters().getParameter("roles");
        if (!roles.isEmpty()) {
            boolean check = false;
            for (String role : roles) {
                if (!this.permissionSummary.hasRole(role)) continue;
                check = true;
                break;
            }
            if (!check) {
                return null;
            }
        }
        if (originalFilterUnit instanceof CorpusExtractFilterUnit) {
            CorpusExtractDef filteredCorpusExtractDef = this.filter(((CorpusExtractFilterUnit)originalFilterUnit).getCorpusExtractDef());
            if (filteredCorpusExtractDef != null) {
                return FilterUnitCatalog.corpusExtract(filteredCorpusExtractDef, originalFilterUnit.getParameters());
            }
            return null;
        }
        if (originalFilterUnit instanceof ThesaurusExtractFilterUnit) {
            ThesaurusExtractDef filteredThesaurusExtractDef = this.filter(((ThesaurusExtractFilterUnit)originalFilterUnit).getThesaurusExtractDef());
            if (filteredThesaurusExtractDef != null) {
                return FilterUnitCatalog.thesaurusExtract(filteredThesaurusExtractDef, originalFilterUnit.getParameters());
            }
            return null;
        }
        return originalFilterUnit;
    }

    public static ExtractionDef run(ExtractionDef extractionDef, ExtractionContext extractionContext) {
        List<ThesaurusExtractDef> filteredStaticThesaurusList;
        List<CorpusExtractDef> filteredStaticCorpusList;
        PermissionSummary permissionSummary = extractionContext.getPermissionSummary();
        if (permissionSummary.isFichothequeAdmin()) {
            return extractionDef;
        }
        ExtractionDefFilterEngine engine = new ExtractionDefFilterEngine(permissionSummary);
        CorpusExtractDef filteredDynamicCorpusExtractDef = engine.filter(extractionDef.getDynamicCorpusExtractDef());
        ThesaurusExtractDef filteredDynamicThesaurusExtractDef = engine.filter(extractionDef.getDynamicThesaurusExtractDef());
        List<CorpusExtractDef> originalStaticCorpusList = extractionDef.getStaticCorpusExtractDefList();
        if (originalStaticCorpusList.isEmpty()) {
            filteredStaticCorpusList = originalStaticCorpusList;
        } else {
            filteredStaticCorpusList = new ArrayList<CorpusExtractDef>();
            for (CorpusExtractDef originalCorpusExtractDef : originalStaticCorpusList) {
                CorpusExtractDef filteredCorpusExtractDef = engine.filter(originalCorpusExtractDef);
                if (filteredCorpusExtractDef == null) continue;
                filteredStaticCorpusList.add(filteredCorpusExtractDef);
            }
        }
        List<ThesaurusExtractDef> originalStaticThesaurusList = extractionDef.getStaticThesaurusExtractDefList();
        if (originalStaticThesaurusList.isEmpty()) {
            filteredStaticThesaurusList = originalStaticThesaurusList;
        } else {
            filteredStaticThesaurusList = new ArrayList<ThesaurusExtractDef>();
            for (ThesaurusExtractDef originalThesaurusExtractDef : originalStaticThesaurusList) {
                ThesaurusExtractDef filteredThesaurusExtractDef = engine.filter(originalThesaurusExtractDef);
                if (filteredThesaurusExtractDef == null) continue;
                filteredStaticThesaurusList.add(filteredThesaurusExtractDef);
            }
        }
        return new FilteredExtractionDef(extractionDef, filteredDynamicCorpusExtractDef, filteredDynamicThesaurusExtractDef, filteredStaticCorpusList, filteredStaticThesaurusList);
    }

    private static class FilteredCorpusExtractDef
    implements CorpusExtractDef {
        private final CorpusExtractDef originalCorpusExtractDef;
        private final FicheFilter filteredFicheFilter;
        private final List<FicheCondition.Entry> filteredConditionEntryList;

        private FilteredCorpusExtractDef(CorpusExtractDef originalCorpusExtractDef, FicheFilter filteredFicheFilter, List<FicheCondition.Entry> filteredConditionEntryList) {
            this.originalCorpusExtractDef = originalCorpusExtractDef;
            this.filteredFicheFilter = filteredFicheFilter;
            this.filteredConditionEntryList = filteredConditionEntryList;
        }

        @Override
        public String getName() {
            return this.originalCorpusExtractDef.getName();
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.originalCorpusExtractDef.getTagNameInfo();
        }

        @Override
        public FicheFilter getFicheFilter() {
            return this.filteredFicheFilter;
        }

        @Override
        public List<FicheCondition.Entry> getConditionEntryList() {
            return this.filteredConditionEntryList;
        }

        @Override
        public boolean hasClauseObjects() {
            return this.originalCorpusExtractDef.hasClauseObjects();
        }

        @Override
        public Object getClauseObject(String name) {
            return this.originalCorpusExtractDef.getClauseObject(name);
        }

        @Override
        public boolean hasBooleanParameters() {
            return this.originalCorpusExtractDef.hasBooleanParameters();
        }

        @Override
        public boolean getBooleanParameter(String name) {
            return this.originalCorpusExtractDef.getBooleanParameter(name);
        }
    }

    private static class FilteredMotcleFilter
    implements MotcleFilter {
        private final MotcleFilter originalMotcleFilter;
        private final List<FilterUnit> filterUnitList;

        private FilteredMotcleFilter(MotcleFilter originalMotcleFilter, List<FilterUnit> filterUnitList) {
            this.originalMotcleFilter = originalMotcleFilter;
            this.filterUnitList = filterUnitList;
        }

        @Override
        public short getType() {
            return this.originalMotcleFilter.getType();
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.originalMotcleFilter.getTagNameInfo();
        }

        @Override
        public boolean isNoneFiltering() {
            return this.originalMotcleFilter.isNoneFiltering();
        }

        @Override
        public boolean withIcon() {
            return this.originalMotcleFilter.withIcon();
        }

        @Override
        public boolean withLevel() {
            return this.originalMotcleFilter.withLevel();
        }

        @Override
        public boolean withLabels() {
            return this.originalMotcleFilter.withLabels();
        }

        @Override
        public boolean withFicheStylePhrase() {
            return this.originalMotcleFilter.withFicheStylePhrase();
        }

        @Override
        public MotcleFilter getChildrenFilter() {
            return this.originalMotcleFilter.getChildrenFilter();
        }

        @Override
        public MotcleFilter getParentFilter() {
            return this.originalMotcleFilter.getParentFilter();
        }

        @Override
        public MotcleFilter getNextFilter() {
            return this.originalMotcleFilter.getNextFilter();
        }

        @Override
        public MotcleFilter getPreviousFilter() {
            return this.originalMotcleFilter.getPreviousFilter();
        }

        @Override
        public List<FilterUnit> getFilterUnitList() {
            return this.filterUnitList;
        }
    }

    private static class FilteredThesaurusExtractDef
    implements ThesaurusExtractDef {
        private final ThesaurusExtractDef originalThesaurusExtractDef;
        private final MotcleFilter filteredMotcleFilter;
        private final List<MotcleCondition.Entry> filteredConditionEntryList;

        private FilteredThesaurusExtractDef(ThesaurusExtractDef originalThesaurusExtractDef, MotcleFilter filteredMotcleFilter, List<MotcleCondition.Entry> filteredConditionEntryList) {
            this.originalThesaurusExtractDef = originalThesaurusExtractDef;
            this.filteredMotcleFilter = filteredMotcleFilter;
            this.filteredConditionEntryList = filteredConditionEntryList;
        }

        @Override
        public String getName() {
            return this.originalThesaurusExtractDef.getName();
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.originalThesaurusExtractDef.getTagNameInfo();
        }

        @Override
        public MotcleFilter getMotcleFilter() {
            return this.filteredMotcleFilter;
        }

        @Override
        public List<MotcleCondition.Entry> getConditionEntryList() {
            return this.filteredConditionEntryList;
        }

        @Override
        public boolean hasBooleanParameters() {
            return this.originalThesaurusExtractDef.hasBooleanParameters();
        }

        @Override
        public boolean getBooleanParameter(String name) {
            return this.originalThesaurusExtractDef.getBooleanParameter(name);
        }
    }

    private static class FilteredExtractionDef
    implements ExtractionDef {
        private final ExtractionDef originalExtractionDef;
        private final CorpusExtractDef dynamicCorpusExtractDef;
        private final ThesaurusExtractDef dynamicThesaurusExtractDef;
        private final List<CorpusExtractDef> staticCorpusList;
        private final List<ThesaurusExtractDef> staticThesaurusList;

        private FilteredExtractionDef(ExtractionDef originalExtractionDef, CorpusExtractDef dynamicCorpusExtractDef, ThesaurusExtractDef dynamicThesaurusExtractDef, List<CorpusExtractDef> staticCorpusList, List<ThesaurusExtractDef> staticThesaurusList) {
            this.originalExtractionDef = originalExtractionDef;
            this.dynamicCorpusExtractDef = dynamicCorpusExtractDef;
            this.dynamicThesaurusExtractDef = dynamicThesaurusExtractDef;
            this.staticCorpusList = staticCorpusList;
            this.staticThesaurusList = staticThesaurusList;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.originalExtractionDef.getTagNameInfo();
        }

        @Override
        public CorpusExtractDef getDynamicCorpusExtractDef() {
            return this.dynamicCorpusExtractDef;
        }

        @Override
        public ThesaurusExtractDef getDynamicThesaurusExtractDef() {
            return this.dynamicThesaurusExtractDef;
        }

        @Override
        public TagNameInfo getStaticTagNameInfo() {
            return this.originalExtractionDef.getStaticTagNameInfo();
        }

        @Override
        public List<CorpusExtractDef> getStaticCorpusExtractDefList() {
            return this.staticCorpusList;
        }

        @Override
        public List<ThesaurusExtractDef> getStaticThesaurusExtractDefList() {
            return this.staticThesaurusList;
        }
    }
}

