/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.balayage.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.tools.exportation.balayage.BalayageDefBuilder;
import net.fichotheque.tools.exportation.balayage.BalayagePostscriptumBuilder;
import net.fichotheque.tools.exportation.balayage.dom.BalayageUnitsDOMReader;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class BalayageDefDOMReader {
    private final Fichotheque fichotheque;
    private final BalayageDefBuilder balayageDefBuilder;
    private final MessageHandler messageHandler;

    public BalayageDefDOMReader(Fichotheque fichotheque, BalayageDefBuilder balayageDefBuilder, MessageHandler messageHandler) {
        this.fichotheque = fichotheque;
        this.balayageDefBuilder = balayageDefBuilder;
        this.messageHandler = messageHandler;
    }

    public BalayageDefDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static BalayageDefDOMReader init(Fichotheque fichotheque, BalayageDefBuilder balayageDefBuilder, MessageHandler messageHandler) {
        return new BalayageDefDOMReader(fichotheque, balayageDefBuilder, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": {
                    try {
                        LabelUtils.readLabel(element, BalayageDefDOMReader.this.balayageDefBuilder);
                    }
                    catch (ParseException ile) {
                        DomMessages.wrongLangAttribute(BalayageDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                case "langs": {
                    DOMUtils.readChildren(element, new LangsConsumer());
                    break;
                }
                case "target-name": {
                    BalayageDefDOMReader.this.balayageDefBuilder.setTargetName(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "target-path": {
                    String targetPath = DOMUtils.readSimpleElement(element);
                    try {
                        RelativePath relativePath = RelativePath.parse(targetPath);
                        BalayageDefDOMReader.this.balayageDefBuilder.setTargetPath(relativePath);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongElementValue(BalayageDefDOMReader.this.messageHandler, tagName, targetPath);
                    }
                    break;
                }
                case "default-lang-option": {
                    try {
                        BalayageDefDOMReader.this.balayageDefBuilder.setDefaultLangOption(DOMUtils.readSimpleElement(element));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case "ignore-transformation": {
                    BalayageDefDOMReader.this.balayageDefBuilder.setIgnoreTransformation(true);
                    break;
                }
                case "postscriptum": {
                    DOMUtils.readChildren(element, new PostscriptumConsumer(BalayageDefDOMReader.this.balayageDefBuilder.getBalayagePostscriptumBuilder()));
                    break;
                }
                case "units": {
                    BalayageUnitsDOMReader.init(BalayageDefDOMReader.this.fichotheque, BalayageDefDOMReader.this.balayageDefBuilder, BalayageDefDOMReader.this.messageHandler).read(element);
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(BalayageDefDOMReader.this.balayageDefBuilder.getAttributesBuilder(), element);
                    break;
                }
                default: {
                    if (SelectionDOMUtils.readSelectionOptions(BalayageDefDOMReader.this.balayageDefBuilder.getSelectionOptionsBuilder(), BalayageDefDOMReader.this.fichotheque, element)) break;
                    DomMessages.unknownTagWarning(BalayageDefDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }

    private class PostscriptumConsumer
    implements Consumer<Element> {
        private final BalayagePostscriptumBuilder balayagePostscriptumBuilder;

        private PostscriptumConsumer(BalayagePostscriptumBuilder balayagePostscriptumBuilder) {
            this.balayagePostscriptumBuilder = balayagePostscriptumBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "script": 
                case "command": {
                    String script = XMLUtils.getData(element);
                    if (script.length() <= 0) break;
                    this.balayagePostscriptumBuilder.addExternalScript(script);
                    break;
                }
                case "scrutari": {
                    String scrutari = XMLUtils.getData(element);
                    if (scrutari.length() <= 0) break;
                    this.balayagePostscriptumBuilder.addScrutariExport(scrutari);
                    break;
                }
                case "sql": {
                    String sql = XMLUtils.getData(element);
                    if (sql.length() <= 0) break;
                    this.balayagePostscriptumBuilder.addSqlExport(sql);
                }
            }
        }
    }

    private class LangsConsumer
    implements Consumer<Element> {
        private LangsConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lang")) {
                String langString = DOMUtils.readSimpleElement(element);
                try {
                    Lang lang = Lang.parse(langString);
                    BalayageDefDOMReader.this.balayageDefBuilder.addLang(lang);
                }
                catch (ParseException lie) {
                    DomMessages.wrongElementValue(BalayageDefDOMReader.this.messageHandler, tagName, langString);
                }
            } else {
                DomMessages.unknownTagWarning(BalayageDefDOMReader.this.messageHandler, tagName);
            }
        }
    }
}

