/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.permission;

import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;

public interface PermissionSummary {
    public static final int SUMMARYLEVEL_0_NONE = 0;
    public static final int SUMMARYLEVEL_1_FICHE_OWN = 1;
    public static final int SUMMARYLEVEL_2_FICHE_SPHERE = 2;
    public static final int SUMMARYLEVEL_3_JUNCTION_TEST = 3;
    public static final int SUMMARYLEVEL_4_ALL = 4;
    public static final int SUMMARYLEVEL_5_ADMIN = 5;

    public int getReadLevel(SubsetKey var1);

    public int getWriteLevel(SubsetKey var1);

    public boolean canCreate(SubsetKey var1);

    public boolean isSubsetAdmin(SubsetKey var1);

    public boolean isFichothequeAdmin();

    public boolean hasRole(String var1);

    public boolean canDo(String var1);

    public Predicate<Subset> getSubsetAccessPredicate();

    default public boolean hasAccess(SubsetKey subsetKey) {
        return this.getReadLevel(subsetKey) != 0;
    }

    default public boolean hasAccess(Subset subset) {
        return this.getReadLevel(subset.getSubsetKey()) != 0;
    }

    default public boolean canCreate(Subset subset) {
        return this.canCreate(subset.getSubsetKey());
    }

    public boolean canRead(SubsetItem var1);

    public boolean canWrite(SubsetItem var1);

    default public boolean isPartialAdmin() {
        return this.canDo("balayagerun");
    }
}

