/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.runners;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.balayage.BalayageSession;
import fr.exemole.bdfserver.api.balayage.LockedBalayageException;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageEngine;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageInitializer;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageLog;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.io.File;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.balayage.BalayageMode;
import net.fichotheque.utils.BalayageUtils;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LogUtils;

public final class BalayageRunner {
    public static final String INIT_ERROR = "init_error";
    public static final String LOCK_ERROR = "lock_error";

    private BalayageRunner() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result run(BalayageDescription balayageDescription, String mode, BdfServer bdfServer, PathConfiguration pathConfiguration) {
        BalayageDef balayageDef = balayageDescription.getBalayageDef();
        String balayageName = balayageDef.getName();
        try (BalayageSession session = bdfServer.getBalayageManager().openBalayageSession(balayageName);){
            BalayageMode balayageMode;
            BalayageInitializer balayageInitializer = new BalayageInitializer(bdfServer, balayageDescription, pathConfiguration);
            if (balayageInitializer.hasError()) {
                Result result2 = new Result(LogUtils.error(balayageInitializer.getErrorMessageKey(), balayageInitializer.getErrorMessageValue()));
                return result2;
            }
            if (mode != null && (balayageMode = BalayageUtils.getMode(balayageDef, mode)) != null) {
                balayageInitializer.setBalayageMode(balayageMode);
            }
            try (BalayageLog balayageLog = new BalayageLog(balayageName, BalayageRunner.getBalayageLogFile(bdfServer, balayageName, mode));){
                BalayageEngine balayageEngine = balayageInitializer.getBalayageEngine(balayageLog);
                balayageEngine.run();
                Result result = new Result(balayageLog);
                return result;
            }
        }
        catch (LockedBalayageException e) {
            return new Result(LogUtils.error("_ error.existing.balayagesession", balayageName));
        }
    }

    private static File getBalayageLogFile(BdfServer bdfServer, String balayageName, String mode) {
        File logDirectory = ConfigurationUtils.getLogDirectory(bdfServer);
        mode = mode == null ? "" : "_" + mode;
        return new File(logDirectory, "balayage_" + balayageName + mode + ".txt");
    }

    public static class Result {
        private final CommandMessage commandMessage;
        private final BalayageLog balayageLog;

        private Result(CommandMessage commandMessage) {
            this.commandMessage = commandMessage;
            this.balayageLog = null;
        }

        private Result(BalayageLog balayageLog) {
            this.balayageLog = balayageLog;
            this.commandMessage = null;
        }

        public boolean hasError() {
            return this.commandMessage != null;
        }

        public CommandMessage getError() {
            return this.commandMessage;
        }

        public BalayageLog getBalayageLog() {
            return this.balayageLog;
        }
    }
}

