/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.overview;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.util.HashSet;
import java.util.Set;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.include.ExtendedIncludeKey;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.MultiStringable;
import net.mapeadores.util.text.Phrase;

public class CorpusOverview {
    private final BdfServer bdfServer;
    private final Corpus corpus;
    private final CorpusMetadata corpusMetadata;
    private final StringBuilder buf;
    private final Set<String> alreadySet = new HashSet<String>();

    private CorpusOverview(BdfServer bdfServer, Corpus corpus) {
        this.bdfServer = bdfServer;
        this.corpus = corpus;
        this.corpusMetadata = corpus.getCorpusMetadata();
        this.buf = new StringBuilder();
    }

    private String run() {
        UiComponents uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        this.metadataBlock(uiComponents);
        this.idBlock();
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            if (uiComponent instanceof CommentUi) {
                CommentUi commentUi = (CommentUi)uiComponent;
                this.commentBlock(commentUi);
                continue;
            }
            if (uiComponent instanceof FieldUi) {
                this.fieldBlock((FieldUi)uiComponent);
                continue;
            }
            if (uiComponent instanceof SpecialIncludeUi) {
                this.specialIncludeBlock((SpecialIncludeUi)uiComponent);
                continue;
            }
            if (uiComponent instanceof SubsetIncludeUi) {
                this.subsetIncludeBlock((SubsetIncludeUi)uiComponent);
                continue;
            }
            if (!(uiComponent instanceof DataUi)) continue;
            this.dataBlock((DataUi)uiComponent);
        }
        return this.buf.toString();
    }

    private void endLine() {
        this.buf.append("\n");
    }

    private void newBlock(String name) {
        this.buf.append("[");
        this.buf.append(name);
        this.buf.append("]");
        this.endLine();
    }

    private void metadataBlock(UiComponents uiComponents) {
        String rawString;
        this.newBlock("metadata");
        this.addLabels("title", this.corpusMetadata.getTitleLabels());
        for (Phrase phrase : this.corpusMetadata.getPhrases()) {
            this.addLabels("phrase_" + phrase.getName(), phrase);
        }
        CorpusField geolocalisationField = this.corpusMetadata.getGeolocalisationField();
        if (geolocalisationField != null) {
            this.append("geolocalisation", geolocalisationField.getFieldString());
        }
        if (!(rawString = this.corpusMetadata.getFieldGeneration().getRawString()).isEmpty()) {
            this.append("fieldgeneration", rawString);
        }
        StringBuilder orderBuf = new StringBuilder();
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            if (orderBuf.length() > 0) {
                orderBuf.append(", ");
            }
            orderBuf.append(uiComponent.getName());
        }
        this.append("order", orderBuf.toString());
        this.addAttributes(this.corpusMetadata.getAttributes());
        this.endLine();
    }

    private void idBlock() {
        this.newBlock("id");
        CorpusField corpusField = this.corpusMetadata.getCorpusField(FieldKey.ID);
        this.addLabels("label", corpusField.getLabels());
        this.endLine();
    }

    private void fieldBlock(FieldUi fieldUi) {
        FieldKey fieldKey = fieldUi.getFieldKey();
        CorpusField corpusField = this.corpusMetadata.getCorpusField(fieldKey);
        this.newBlock(fieldKey.getKeyString());
        if (corpusField.isProp() || corpusField.isInfo()) {
            this.append("type", corpusField.getFicheItemType());
        }
        this.addLabels("label", corpusField.getLabels());
        for (String optionName : corpusField.getOptionNameSet()) {
            Object optionValue = corpusField.getOption(optionName);
            if (optionValue instanceof String) {
                this.append("field." + optionName, (String)optionValue);
                continue;
            }
            if (!(optionValue instanceof MultiStringable)) continue;
            this.append("field." + optionName, ((MultiStringable)optionValue).toString(", "));
        }
        this.addStatus(fieldUi);
        this.addUiOption(fieldUi);
        this.addAttributes(fieldUi.getAttributes());
        this.endLine();
    }

    private void specialIncludeBlock(SpecialIncludeUi includeUi) {
        this.newBlock(includeUi.getName());
        this.addStatus(includeUi);
        this.addCustomLabels(includeUi);
        this.addUiOption(includeUi);
        this.addAttributes(includeUi.getAttributes());
        this.endLine();
    }

    private void subsetIncludeBlock(SubsetIncludeUi includeUi) {
        ExtendedIncludeKey includeKey = includeUi.getExtendedIncludeKey();
        this.newBlock(includeKey.getKeyString());
        this.addStatus(includeUi);
        this.addCustomLabels(includeUi);
        this.addUiOption(includeUi);
        this.addAttributes(includeUi.getAttributes());
        this.endLine();
    }

    private void dataBlock(DataUi dataUi) {
        ExternalSourceDef externalSourceDef = dataUi.getExternalSourceDef();
        this.newBlock(dataUi.getName());
        this.append("type", externalSourceDef.getType());
        for (String paramName : externalSourceDef.getParamNameSet()) {
            this.append("param." + paramName, externalSourceDef.getParam(paramName));
        }
        this.addLabels("label", dataUi.getLabels());
        this.addUiOption(dataUi);
        this.addAttributes(dataUi.getAttributes());
        this.endLine();
    }

    private void commentBlock(CommentUi commentUi) {
        String name = commentUi.getName();
        this.newBlock(name);
        if (!this.alreadySet.contains(name)) {
            this.alreadySet.add(name);
            this.append("location", UiUtils.maskToString(commentUi.getLocation()));
            for (Lang lang : commentUi.getLangs()) {
                this.append("html", lang, commentUi.getHtmlByLang(lang));
            }
            this.addUiOption(commentUi);
        }
        this.endLine();
    }

    private void addLabels(String name, Labels labels) {
        if (labels != null) {
            for (Label label : labels) {
                this.append(name, label.getLang(), label.getLabelString());
            }
        }
    }

    private void addCustomLabels(IncludeUi includeUi) {
        Labels labels = includeUi.getCustomLabels();
        if (labels == null) {
            return;
        }
        this.addLabels("custom", labels);
    }

    private void addAttributes(Attributes attributes) {
        String attributesString = AttributeParser.toString(attributes, "= ", "; ");
        if (attributesString.length() > 0) {
            this.buf.append(attributesString);
            this.endLine();
        }
    }

    private void addStatus(UiComponent uiComponent) {
        String status;
        if (uiComponent.isModifiableStatus() && !(status = uiComponent.getStatus()).equals("default")) {
            this.append("status", status);
        }
    }

    private void addUiOption(UiComponent uiComponent) {
        for (String optionName : uiComponent.getOptionNameSet()) {
            this.append("ui." + optionName, uiComponent.getOptionValue(optionName));
        }
    }

    private void append(String name, CharSequence value) {
        this.buf.append(name);
        this.buf.append("= ");
        this.escape(value);
        this.endLine();
    }

    private void append(String name, Lang lang, CharSequence value) {
        this.buf.append(name);
        this.buf.append('|');
        this.buf.append(lang.toString());
        this.buf.append("= ");
        this.escape(value);
        this.endLine();
    }

    private void append(String name, int value) {
        this.buf.append(name);
        this.buf.append("= ");
        this.buf.append(value);
        this.endLine();
    }

    public static String run(BdfServer bdfServer, Corpus corpus) {
        CorpusOverview corpusOverview = new CorpusOverview(bdfServer, corpus);
        return corpusOverview.run();
    }

    private void escape(CharSequence text) {
        int length = text.length();
        block7: for (int i = 0; i < length; ++i) {
            char carac = text.charAt(i);
            switch (carac) {
                case '\\': {
                    this.buf.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    this.buf.append("\u00b6");
                    continue block7;
                }
                case '\t': {
                    this.buf.append("\\t");
                    continue block7;
                }
                case '\r': {
                    this.buf.append("\\r");
                    continue block7;
                }
                case '\u00b6': {
                    this.buf.append("\\\u00b6");
                    continue block7;
                }
                default: {
                    this.buf.append(carac);
                }
            }
        }
    }
}

