/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.MultiEditor;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.api.central.CentralSphereEditor;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.api.central.CentralUserEditor;
import fr.exemole.bdfserver.multi.commands.AbstractMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.EditOrigin;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.fichotheque.utils.EditOriginUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public abstract class AbstractCentralMultiCommand
extends AbstractMultiCommand {
    public static final String SPHERE_PARAMNAME = "sphere";
    public static final String LOGIN_PARAMNAME = "login";
    public static final String FICHOTHEQUE_PARAMNAME = "fichotheque";
    public static final String STATUS_PARAMNAME = "status";
    public static final String ADMIN_STATUS_PARAMVALUE = "admin";
    public static final String USER_STATUS_PARAMVALUE = "user";
    public static final String READONLY_STATUS_PARAMVALUE = "readonly";
    public static final String INACTIVE_STATUS_PARAMVALUE = "inactive";
    protected CentralSphere centralSphere;
    protected CentralUser centralUser;
    protected MultiEditor multiEditor;
    protected CentralSphereEditor centralSphereEditor;
    protected BdfServer bdfServer;

    public AbstractCentralMultiCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    public void initCentralSphere() throws ErrorMessageException {
        String sphereName = this.getMandatory(SPHERE_PARAMNAME);
        this.centralSphere = this.multi.getCentralSphere(sphereName);
        if (this.centralSphere == null) {
            throw new ErrorMessageException("_ error.unknown.sphere", sphereName);
        }
    }

    public void initCentralUser() throws ErrorMessageException {
        String login = this.getMandatory(LOGIN_PARAMNAME);
        this.centralUser = this.centralSphere.getCentralUser(login);
        if (this.centralUser == null) {
            throw BdfErrors.unknownParameterValue(LOGIN_PARAMNAME, login);
        }
    }

    public void initCentralEditors() {
        EditOrigin editOrigin = EditOriginUtils.newEditOrigin("multi-admin/centralsphere");
        this.multiEditor = this.multi.getMultiEditor(editOrigin);
        this.centralSphereEditor = this.multiEditor.getCentralSphereEditor(this.centralSphere.getName());
    }

    public CentralUserEditor getCentralUserEditor() {
        return this.centralSphereEditor.getCentralUserEditor(this.centralUser.getLogin());
    }

    public void initBdfServer(boolean spherePresence) throws ErrorMessageException {
        String fichothequeName = this.getMandatory(FICHOTHEQUE_PARAMNAME);
        this.bdfServer = this.multi.getBdfServer(fichothequeName);
        boolean here = this.bdfServer.getFichotheque().containsSubset(this.centralSphere.getSphereKey());
        if (spherePresence) {
            if (!here) {
                throw BdfErrors.error("_ error.unknown.sphere", this.centralSphere.getName());
            }
        } else if (here) {
            throw BdfErrors.error("_ error.existing.sphere", this.centralSphere.getName());
        }
    }

    public void saveChanges() {
        this.multiEditor.saveChanges();
    }

    public CentralSphere getCentralSphere() {
        return this.centralSphere;
    }

    public BdfServer getBdfServer() {
        return this.bdfServer;
    }

    public Redacteur getRedacteur() throws ErrorMessageException {
        Sphere sphere = (Sphere)this.bdfServer.getFichotheque().getSubset(this.centralSphere.getSphereKey());
        Redacteur redacteur = sphere.getRedacteurByLogin(this.centralUser.getLogin());
        if (redacteur == null) {
            throw BdfErrors.error("_ error.unknown.redacteur", this.centralUser.getLogin());
        }
        return redacteur;
    }

    public EditSession newEditSession(BdfServer bdfServer, String source) {
        return bdfServer.initEditSession("_admin", source);
    }

    public EditSession newEditSession(String source) {
        return this.newEditSession(this.bdfServer, source);
    }

    public void changeStatus(Redacteur redacteur, SphereEditor sphereEditor, EditSession editSession) {
        String status = this.requestMap.getParameter(STATUS_PARAMNAME);
        if (status != null) {
            this.changeStatus(status, redacteur, sphereEditor, editSession);
        }
    }

    public void changeStatus(String status, Redacteur redacteur, SphereEditor sphereEditor, EditSession editSession) {
        boolean isAdmin = editSession.getBdfServer().getPermissionManager().isAdmin(redacteur);
        if (isAdmin) {
            if (status.equals(ADMIN_STATUS_PARAMVALUE)) {
                return;
            }
            editSession.getBdfServerEditor().setAdmin(redacteur.getGlobalId(), false);
        }
        switch (status) {
            case "readonly": {
                sphereEditor.setStatus(redacteur, READONLY_STATUS_PARAMVALUE);
                break;
            }
            case "inactive": {
                sphereEditor.setStatus(redacteur, INACTIVE_STATUS_PARAMVALUE);
                break;
            }
            case "user": {
                sphereEditor.setStatus(redacteur, "active");
                break;
            }
            case "admin": {
                sphereEditor.setStatus(redacteur, "active");
                editSession.getBdfServerEditor().setAdmin(redacteur.getGlobalId(), true);
            }
        }
    }
}

