/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.importation;

import java.io.IOException;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.html.MetaReport;
import net.mapeadores.util.html.MetaReportUtils;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.MultiStringable;

public class MetaReportJsonProperty
implements JsonProperty {
    private final MetaReport metaReport;

    public MetaReportJsonProperty(MetaReport metaReport) {
        this.metaReport = metaReport;
    }

    @Override
    public String getName() {
        return "metaReport";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        FuzzyDate date;
        jw.object();
        this.writeProperty(jw, "title", MetaReportUtils.getTitle(this.metaReport));
        this.writeProperty(jw, "description", MetaReportUtils.getDescription(this.metaReport));
        Lang lang = MetaReportUtils.getLang(this.metaReport);
        if (lang != null) {
            jw.key("lang").value(lang.toString());
        }
        if ((date = MetaReportUtils.getDate(this.metaReport)) != null) {
            jw.key("date").value(date.toString());
        }
        this.writeProperty(jw, "authors", MetaReportUtils.getAuthors(this.metaReport));
        this.writeProperty(jw, "publishers", MetaReportUtils.getKeywords(this.metaReport));
        this.writeProperty(jw, "keywords", MetaReportUtils.getKeywords(this.metaReport));
        for (String protocolName : this.metaReport.getAvalaibleProtocolSet()) {
            jw.key(protocolName);
            jw.object();
            MetaReport.ProtocolValues protocolValues = this.metaReport.getProtocolValues(protocolName);
            for (String paramName : protocolValues.getParamNameSet()) {
                MultiStringable multiStringable = protocolValues.getValues(paramName);
                jw.key(paramName);
                jw.array();
                for (String value : multiStringable.toStringArray()) {
                    jw.value(value);
                }
                jw.endArray();
            }
            jw.endObject();
        }
        jw.endObject();
    }

    private void writeProperty(JSONWriter jw, String key, String value) throws IOException {
        if (value != null) {
            jw.key(key).value(value);
        }
    }

    private void writeProperty(JSONWriter jw, String key, String[] values) throws IOException {
        if (values != null) {
            jw.key(key);
            jw.array();
            for (String value : values) {
                jw.value(value);
            }
            jw.endArray();
        }
    }
}

