/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.FicheJsLibs;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadResult;
import fr.exemole.bdfserver.tools.filesupload.TmpFileGroup;
import fr.exemole.bdfserver.tools.filesupload.TmpFileInfo;
import fr.exemole.bdfserver.tools.filesupload.UploadError;
import java.util.List;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.localisation.Message;

public class FilesUploadResultHtmlProducer
extends BdfServerHtmlProducer {
    private final FilesUploadResult filesUploadResult;
    private final String callKey;

    public FilesUploadResultHtmlProducer(BdfParameters bdfParameters, FilesUploadResult filesUploadResult, String callKey) {
        super(bdfParameters);
        this.filesUploadResult = filesUploadResult;
        this.callKey = callKey;
        this.setBodyCssClass("global-body-Transparent");
        this.addJsLib(FicheJsLibs.FILESUPLOAD);
    }

    @Override
    public void printHtml() {
        String clientId = this.generateId();
        JsObject args = JsObject.init().put("step", "result").put("clientId", clientId).put("callKey", this.callKey).put("result", this.convertResult());
        this.start();
        this.SCRIPT().__jsObject("FilesUpload.ARGS", args)._SCRIPT();
        this.DIV(HA.id(clientId))._DIV();
        this.end();
    }

    private JsObject convertResult() {
        if (this.filesUploadResult instanceof FilesUploadResult.Unique) {
            return this.convertUniqueResult((FilesUploadResult.Unique)this.filesUploadResult);
        }
        if (this.filesUploadResult instanceof FilesUploadResult.Multi) {
            return this.convertMultiResult((FilesUploadResult.Multi)this.filesUploadResult);
        }
        return null;
    }

    private JsObject convertUniqueResult(FilesUploadResult.Unique uniqueResult) {
        JsObject result = JsObject.init().put("type", "unique").put("tmpFileArray", this.convertTmpFileInfoList(uniqueResult.getTmpFileInfoList())).put("uploadErrorArray", this.convertUploadErrorList(uniqueResult.getUploadErrorList()));
        return result;
    }

    private JsObject convertMultiResult(FilesUploadResult.Multi multiResult) {
        JsObject result = JsObject.init().put("type", "multi").put("groupArray", this.convertTmpFileGroupList(multiResult.getTmpFileGroupList())).put("uploadErrorArray", this.convertUploadErrorList(multiResult.getUploadErrorList()));
        return result;
    }

    private JsObject[] convertTmpFileGroupList(List<TmpFileGroup> tmpFileGroupList) {
        int size = tmpFileGroupList.size();
        JsObject[] array = new JsObject[size];
        for (int i = 0; i < size; ++i) {
            TmpFileGroup tmpFileGroup = tmpFileGroupList.get(i);
            array[i] = JsObject.init().put("originalBasename", tmpFileGroup.getOriginalBasename()).put("normalizedBasename", tmpFileGroup.getNormalizedBasename()).put("tmpFileArray", this.convertTmpFileInfoList(tmpFileGroup.getTmpFileInfoList()));
        }
        return array;
    }

    private JsObject[] convertTmpFileInfoList(List<TmpFileInfo> tmpFileInfoList) {
        int size = tmpFileInfoList.size();
        JsObject[] array = new JsObject[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.convertTmpFileInfo(tmpFileInfoList.get(i));
        }
        return array;
    }

    private JsObject convertTmpFileInfo(TmpFileInfo tmpFileInfo) {
        return JsObject.init().put("extension", tmpFileInfo.getExtension()).put("tmpFileName", tmpFileInfo.getTmpFileName()).put("originalBasename", tmpFileInfo.getOriginalBasename()).put("normalizedBasename", tmpFileInfo.getNormalizedBasename());
    }

    private JsObject[] convertUploadErrorList(List<UploadError> uploadErrorList) {
        int size = uploadErrorList.size();
        JsObject[] array = new JsObject[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.convertUploadError(uploadErrorList.get(i));
        }
        return array;
    }

    private JsObject convertUploadError(UploadError uploadError) {
        return JsObject.init().put("tmpFile", this.convertTmpFileInfo(uploadError.getTmpFileInfo())).put("message", this.convertMessage(uploadError.getMessage()));
    }

    private JsObject convertMessage(Message message) {
        return JsObject.init().put("key", message.getMessageKey()).put("text", this.getLocalization(message)).put("values", message.getMessageValues());
    }
}

