/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.addenda;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.DocumentJsLibs;
import net.fichotheque.addenda.Addenda;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.logging.CommandMessage;

public class DocumentUploadHtmlProducer
extends BdfServerHtmlProducer {
    private final String callKey;
    private final Addenda addenda;
    private final boolean newUpload;

    private DocumentUploadHtmlProducer(BdfParameters bdfParameters, String callKey, Addenda addenda, boolean newUpload) {
        super(bdfParameters);
        this.callKey = callKey;
        this.addenda = addenda;
        this.newUpload = newUpload;
        this.addJsLib(DocumentJsLibs.UPLOAD);
    }

    public static DocumentUploadHtmlProducer newNewUpload(BdfParameters bdfParameters, String callKey, Addenda addenda) {
        DocumentUploadHtmlProducer producer = new DocumentUploadHtmlProducer(bdfParameters, callKey, addenda, true);
        return producer;
    }

    public static DocumentUploadHtmlProducer newVersionUpload(BdfParameters bdfParameters, String callKey, Addenda addenda) {
        DocumentUploadHtmlProducer producer = new DocumentUploadHtmlProducer(bdfParameters, callKey, addenda, false);
        producer.setBodyCssClass("global-body-Transparent");
        return producer;
    }

    @Override
    public void printHtml() {
        String clientId = this.generateId();
        JsObject args = JsObject.init().put("clientId", clientId).put("callKey", this.callKey).put("newUpload", this.newUpload).put("addenda", this.addenda.getSubsetName());
        if (this.newUpload) {
            args.put("errorPage", "document-upload-new").put("resultPage", "document-change");
        } else {
            args.put("errorPage", "document-upload-version").put("resultPage", "document-upload-confirm");
        }
        CommandMessage cm = this.getCommandMessage();
        if (cm != null) {
            args.put("errorMessage", this.getLocalization(cm));
        }
        this.startLoc(this.newUpload ? "_ title.addenda.documentcreate" : "_ title.addenda.documentchange");
        this.SCRIPT().__jsObject("AddendaDoc.Upload.ARGS", args)._SCRIPT();
        this.DIV(HA.id(clientId).classes("document-Client"))._DIV();
        this.end();
    }
}

