/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.addenda;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.DocumentJsLibs;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.text.NumberFormat;
import net.fichotheque.tools.parsers.DocumentChangeInfo;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.primitives.FileLength;
import net.mapeadores.util.text.FileName;

public class DocumentUploadConfirmHtmlProducer
extends BdfServerHtmlProducer {
    private final String callKey;
    private final DocumentChangeInfo documentChangeInfo;
    private final FileLength fileLength;

    public DocumentUploadConfirmHtmlProducer(BdfParameters bdfParameters, String callKey, DocumentChangeInfo documentChangeInfo, FileLength fileLength) {
        super(bdfParameters);
        this.callKey = callKey;
        this.documentChangeInfo = documentChangeInfo;
        this.fileLength = fileLength;
        this.setBodyCssClass("global-body-Transparent");
        this.addJsLib(DocumentJsLibs.UPLOADCONFIRM);
    }

    @Override
    public void printHtml() {
        String clientId = this.generateId();
        FileName fileName = this.documentChangeInfo.getTmpFileName(0);
        String fileNameString = fileName.toString();
        String href = ConfigurationUtils.getTmpRelativeUrl(fileNameString);
        NumberFormat format = NumberFormat.getInstance(this.getFormatLocale());
        String sizeUnit = this.fileLength.getRoundType() == 1 ? LocalisationUtils.getKibiOctet(this.getFormatLocale()) : LocalisationUtils.getMebiOctet(this.getFormatLocale());
        JsObject args = JsObject.init().put("clientId", clientId).put("callKey", this.callKey).put("tmpFileName", fileNameString).put("extension", fileName.getExtension()).put("tmpUrl", href).put("size", format.format(this.fileLength.getRoundedValue())).put("sizeUnit", sizeUnit);
        this.start();
        this.SCRIPT().__jsObject("AddendaDoc.UploadConfirm.ARGS", args)._SCRIPT();
        this.DIV(HA.id(clientId).classes("document-Client"))._DIV();
        this.end();
    }
}

