/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.selection;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.utils.selection.RangeConditionBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.Range;
import net.mapeadores.util.primitives.Ranges;
import net.mapeadores.util.request.RequestMap;

public class UserSelectionByFicheCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UserSelectionByFiche";
    private FicheMeta ficheMeta;

    public UserSelectionByFicheCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FicheQuery ficheQuery = this.toFicheQuery();
        this.bdfServer.getSelectionManager().setFicheSelection(this.bdfUser, ficheQuery, "id-asc");
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.ficheMeta = this.requestHandler.getMandatoryFicheMeta(true);
    }

    private FicheQuery toFicheQuery() {
        Ranges ranges = new Ranges();
        ranges.addRange(new Range(this.ficheMeta.getId(), this.ficheMeta.getId()));
        RangeCondition rangeCondition = RangeConditionBuilder.init(ranges).toRangeCondition();
        return FicheQueryBuilder.init().addCorpus(this.ficheMeta.getCorpus()).setIdRangeCondition(rangeCondition).toFicheQuery();
    }
}

