/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.importation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.importation.ImportationFileUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.Metadata;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.importation.LabelImport;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.importation.LabelImportBuilder;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.coupleparser.Couple;
import net.mapeadores.util.text.coupleparser.CoupleParser;
import net.mapeadores.util.text.coupleparser.ErrorCouple;
import net.mapeadores.util.text.coupleparser.IdalphaCouple;

public class LabelImportParseCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "LabelImportParse";
    public static final String COMMANDKEY = "_ IMP-03";
    public static final String CONTENT_PARAMNAME = "content";
    public static final String LANG_PARAMNAME = "lang";
    public static final String SEPARATOR_PARAMNAME = "separator";
    private String content;
    private char separator = (char)10;
    private Lang lang;

    public LabelImportParseCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        ParseResultBuilder parseResultBuilder = new ParseResultBuilder("labelimport");
        LabelImport labelImport = this.parse(parseResultBuilder, this.content, this.separator);
        try {
            File tmpFile = ImportationFileUtils.saveTmpXml(this.bdfServer, labelImport);
            parseResultBuilder.setPath(tmpFile.getName());
        }
        catch (IOException ioe) {
            throw BdfErrors.ioException(ioe);
        }
        this.putResultObject("obj.parseresult", parseResultBuilder.toParseResult());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.content = this.getMandatory(CONTENT_PARAMNAME);
        String langString = this.getMandatory(LANG_PARAMNAME);
        try {
            this.lang = Lang.parse(langString);
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(LANG_PARAMNAME, langString);
        }
        String separatorValue = this.requestHandler.getTrimedParameter(SEPARATOR_PARAMNAME);
        if (!separatorValue.isEmpty()) {
            try {
                this.separator = StringUtils.stringToChar(separatorValue);
            }
            catch (IllegalArgumentException iae) {
                throw BdfErrors.wrongParameterValue(SEPARATOR_PARAMNAME, separatorValue);
            }
        }
    }

    private LabelImport parse(ParseResultBuilder parseResultBuilder, String content, char separator) {
        LineMessageHandler lineMessageHandler = parseResultBuilder.getLineMessageHandler();
        LabelImportBuilder labelImportBuilder = new LabelImportBuilder(this.lang);
        CoupleParser coupleParser = new CoupleParser(2);
        coupleParser.setSeparator(separator);
        for (Couple couple : coupleParser.parse(content)) {
            int lineNumber;
            if (couple instanceof ErrorCouple) {
                lineMessageHandler.addMessage("severe.parse", couple.getLineNumber(), "_ error.wrong.tableimport.line", couple.getValue());
                continue;
            }
            IdalphaCouple idalphaCouple = (IdalphaCouple)couple;
            CleanedString value = CleanedString.newInstance(couple.getValue());
            String idalpha = idalphaCouple.getIdalpha();
            boolean doublon = parseResultBuilder.checkDoublon(idalpha, lineNumber = couple.getLineNumber());
            if (doublon) continue;
            int idx = idalpha.indexOf(47);
            if (idx < 0) {
                lineMessageHandler.addMessage("severe.parse", lineNumber, "_ error.wrong.idalpha", idalpha);
                continue;
            }
            String part1 = idalpha.substring(0, idx);
            String part2 = idalpha.substring(idx + 1);
            if (part1.length() == 0) {
                lineMessageHandler.addMessage("severe.parse", lineNumber, "_ error.empty.tableimport.firstkeypart", idalpha);
            } else if (part2.length() == 0) {
                lineMessageHandler.addMessage("severe.parse", lineNumber, "_ error.empty.tableimport.secondkeypart", idalpha);
            }
            if (part1.equals("fichotheque")) {
                this.parseFichothequeMetadata(this.fichotheque.getFichothequeMetadata(), parseResultBuilder, labelImportBuilder, idalpha, lineNumber, part2, value);
                continue;
            }
            try {
                SubsetKey subsetKey = SubsetKey.parse(part1);
                Subset subset = this.fichotheque.getSubset(subsetKey);
                if (subset == null) {
                    lineMessageHandler.addMessage("severe.fichotheque", lineNumber, "_ error.unknown.subset", idalpha);
                    continue;
                }
                if (subset instanceof Corpus) {
                    this.parseCorpus((Corpus)subset, parseResultBuilder, labelImportBuilder, idalpha, lineNumber, part2, value);
                    continue;
                }
                this.parseSubsetMetadata(subset, parseResultBuilder, labelImportBuilder, idalpha, lineNumber, part2, value);
            }
            catch (ParseException pe) {
                lineMessageHandler.addMessage("severe.fichotheque", lineNumber, "_ error.unknown.tableimport.firstkeypart", idalpha);
            }
        }
        return labelImportBuilder.toLabelImport();
    }

    private void parseFichothequeMetadata(Metadata fichothequeMetadata, ParseResultBuilder parseResultBuilder, LabelImportBuilder labelImportBuilder, String idString, int lineNumber, String part2, CleanedString value) {
        LineMessageHandler lineMessageHandler = parseResultBuilder.getLineMessageHandler();
        if (part2.equals("title")) {
            labelImportBuilder.addFichothequePhrase(null, value);
            String[] array = this.getValueArray(fichothequeMetadata.getTitleLabels(), value);
            parseResultBuilder.addResult(idString, idString, array, lineNumber);
        } else {
            String phraseName = LabelImportParseCommand.toPhraseName(part2);
            if (phraseName == null) {
                lineMessageHandler.addMessage("severe.parse", lineNumber, "_ error.wrong.phrasename", idString);
            } else {
                labelImportBuilder.addFichothequePhrase(phraseName, value);
                String[] array = this.getValueArray(fichothequeMetadata.getPhrases().getPhrase(phraseName), value);
                parseResultBuilder.addResult(idString, idString, array, lineNumber);
            }
        }
    }

    private void parseCorpus(Corpus corpus, ParseResultBuilder parseResultBuilder, LabelImportBuilder labelImportBuilder, String idString, int lineNumber, String part2, CleanedString value) {
        LineMessageHandler lineMessageHandler = parseResultBuilder.getLineMessageHandler();
        if (!this.parseSubsetMetadata(corpus, parseResultBuilder, labelImportBuilder, idString, lineNumber, part2, value)) {
            try {
                FieldKey fieldKey = FieldKey.parse(part2);
                CorpusField corpusField = corpus.getCorpusMetadata().getCorpusField(fieldKey);
                if (corpusField == null) {
                    lineMessageHandler.addMessage("severe.fichotheque", lineNumber, "_ error.unknown.fieldkey", idString);
                } else {
                    labelImportBuilder.addFieldKeyImport(corpus, fieldKey, value);
                    String[] array = this.getValueArray(corpusField, value);
                    parseResultBuilder.addResult(idString, idString, array, lineNumber);
                }
            }
            catch (ParseException pe) {
                try {
                    IncludeKey includeKey = IncludeKey.parse(part2);
                    labelImportBuilder.addIncludeKeyImport(corpus, includeKey, value);
                    String[] array = this.getValueArray(corpus, includeKey, value);
                    parseResultBuilder.addResult(idString, idString, array, lineNumber);
                }
                catch (ParseException pe2) {
                    lineMessageHandler.addMessage("severe.fichotheque", lineNumber, "_ error.unknown.key", idString);
                }
            }
        }
    }

    private boolean parseSubsetMetadata(Subset subset, ParseResultBuilder parseResultBuilder, LabelImportBuilder labelImportBuilder, String idString, int lineNumber, String part2, CleanedString value) {
        LineMessageHandler lineMessageHandler = parseResultBuilder.getLineMessageHandler();
        if (part2.equals("title")) {
            labelImportBuilder.addSubsetPhrase(subset, null, value);
            String[] array = this.getValueArray(subset.getMetadata().getTitleLabels(), value);
            parseResultBuilder.addResult(idString, idString, array, lineNumber);
            return true;
        }
        String phraseName = LabelImportParseCommand.toPhraseName(part2);
        if (phraseName == null) {
            if (!subset.getSubsetKey().isCorpusSubset()) {
                lineMessageHandler.addMessage("_ error.wrong.phrasename", lineNumber, idString, new Object[0]);
            }
            return false;
        }
        labelImportBuilder.addSubsetPhrase(subset, phraseName, value);
        String[] array = this.getValueArray(subset.getMetadata().getPhrases().getPhrase(phraseName), value);
        parseResultBuilder.addResult(idString, idString, array, lineNumber);
        return true;
    }

    private static String toPhraseName(String s) {
        if (s.startsWith("phrase_")) {
            return s.substring("phrase_".length());
        }
        return null;
    }

    private String[] getValueArray(Labels oldLabels, CleanedString value) {
        Label label;
        String oldValue = "";
        if (oldLabels != null && (label = oldLabels.getLabel(this.lang)) != null) {
            oldValue = label.getLabelString();
        }
        String newValue = "";
        if (value != null) {
            newValue = value.toString();
        }
        String[] array = new String[]{oldValue, newValue};
        return array;
    }

    private String[] getValueArray(CorpusField corpusField, CleanedString value) {
        String oldValue = "";
        Label label = corpusField.getLabels().getLabel(this.lang);
        if (label != null) {
            oldValue = label.getLabelString();
        }
        String newValue = "";
        if (value != null) {
            newValue = value.toString();
        }
        String[] array = new String[]{oldValue, newValue};
        return array;
    }

    private String[] getValueArray(Corpus corpus, IncludeKey includeKey, CleanedString value) {
        Label label;
        Labels labels;
        UiComponents uiComponents = this.bdfServer.getUiManager().getMainUiComponents(corpus);
        IncludeUi includeUi = (IncludeUi)uiComponents.getUiComponent(includeKey);
        String oldValue = "";
        if (includeUi != null && (labels = includeUi.getCustomLabels()) != null && (label = labels.getLabel(this.lang)) != null) {
            oldValue = label.getLabelString();
        }
        String newValue = "";
        if (value != null) {
            newValue = value.toString();
        }
        String[] array = new String[]{oldValue, newValue};
        return array;
    }
}

